import dw::http::Types

fun generateBody(config: { body?: Any, headers?: Types::HttpHeaders, writerOptions?: Dictionary<Any> }): {
  body?: Binary,
  headers: Types::HttpHeaders
} =
  if(config.body? == false)
    { headers: config.headers default {} }
  else
    using(
      contentType = config.headers['Content-Type'] default (
        config.body match {
          case is Binary -> 'application/octet-stream'
          case is dw::module::Multipart::Multipart -> 'multipart/form-data; boundary=$(config.writerOptions.boundary default dw::module::Multipart::generateBoundary())'
          case is String -> 'text/plain'
          else -> 'application/json'
        }
      ),
      writerOptions = config.writerOptions default {} dw::core::Objects::mergeWith {
        (boundary: (contentType scan /boundary=(.*)/)[0][1]) if contentType startsWith 'multipart/form-data'
      },
      body = (config.body match {
               case is Binary -> config.body
               else -> write(config.body, contentType, writerOptions)
             }) as Binary
    )
      {
        headers:
          dw::core::Objects::mergeWith(config.headers, {
            'Content-Type': contentType,
            ('Content-Length': sizeOf(body)) if body is Binary
          }),
        body: body
      }

fun safeRead(mime: String, payload: String | Binary, readerOptions: Object): Any =
  mime match {
    case matches /.*\/octet-stream/ -> payload as Binary
    case matches /.*\/x-binary/ -> payload as Binary
    else ->
      dw::Runtime::try(
        () -> read(payload, mime, readerOptions)
      ).result
  }