import dw::core::Objects
import * from dw::http::Types
import * from dw::http::BodyUtils

var defaultMime = 'application/json'

fun nativeRequest(req: ClientHttpRequest): ClientHttpResponse =
  native("http::HttpRequestFunction")

type CustomOptions = OptionalHttpRequestOptions & {
  readerOptions?: Object,
  writerOptions?: Object
}

fun request(method: String, url: String, config = {}) =
  using(nativeRequestConfig =
    config
      Objects::mergeWith generateBody(config)
      Objects::mergeWith {
        method: method,
        url: url
      }
  )
  using (response = nativeRequest(nativeRequestConfig as HttpRequest))
    {
      request: Objects::mergeWith(
        response.request,
        {
          headers: response.sentHeaders,
          body: response.sentBody
        }
      ),
      response:
        response -- ['request', 'sentHeaders', 'sentBody']
        ++
        if(response.contentType? and response.payload?)
          using(mime = (response.contentType splitBy ";")[0])
          {
            body: safeRead(mime, response.payload, config.readerOptions default {}),
            mime: mime
          }
        else {

        }
    }


