/** The key is the name of the form field, names may be repeated */
type HttpAttachment = {
  contentType: String,
  fileName?: String,
  content: String | Binary
}

type HttpResponseCookie = {
  name: String,
  value: String,
  domain: String,
  comment: String,
  path: String,
  maxAge: Number,
  httpOnly: Boolean,
  secure: Boolean
}

type HttpResponseCookies = {
  _ ?: HttpResponseCookie
}

type HttpHeaders = {
  _ ?: String
}

/** The key is the name of the form field, names may be repeated */
type FormData = {
  _ ?: String
}

type HttpRequest = {
  /** Full url for the request, including domain */
  url: String,
  method: String
}

type HttpResponse = {
  /** Response's raw body */
  payload: Binary,
  /** Full url with domain and queryParameters. This may change with redirections */
  url: String,
  /** Response headers **/
  headers: HttpHeaders,
  /** Example: 200 */
  status: Number,
  /** Example: "OK" */
  statusText: String
}


type OptionalHttpRequestOptions = {
  headers?: HttpHeaders,
  body?: Any,
  /** Do we accept header redirections? */
  allowRedirect?: Boolean,

  /** Accept self signed server certificates */
  allowUnsafeSSL?: Boolean,

  readTimeout?: Number, // default 20000ms
  connTimeout?: Number, // default 10000ms

  /** Should HTTP compression be used?
    * If true, Accept-Encoding: gzip,deflate will be sent with request.
    * If the server response with Content-Encoding: (gzip|deflate) the client will automatically handle decompression
    *
    * This is true by default
    */
  allowCompression?: Boolean
}


type ClientHttpRequest = HttpRequest & OptionalHttpRequestOptions

type ClientHttpResponse = HttpResponse & {
  /** Content type, with encoding stripped */
  contentType: String,

  /** Timing metrics, all values starts at the moment of the call to `request` */
  timers?: {
    dnsLookup: Number,
    initialConnection: Number,
    sslHandshake: Number,
    requestSent: Number,
    firstByteReceived: Number,
    downloadContent: Number,
    connectionClosed: Number,
    bodyParsed: Number
  },
  /** The server may sent multiparts forms as response. This mechanism allows us to retrieve the files */
  attachments?: Array<HttpAttachment>,

  /** Get the parsed cookies from the "Set-Cookie" header **/
  cookies: HttpResponseCookies,

  /** In case of redirection */
  location?: String
}