/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions;

import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.client.UndertowClient;
import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.Cookies;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.Function1Value;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionParameter$;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.WeaveFunction1;
import org.mule.weave.v2.module.http.functions.HttpRequestFunction$;
import org.mule.weave.v2.module.http.functions.HttpRequestFunction$$anon$3$;
import org.mule.weave.v2.module.http.undertow.ByteReadChannelListener;
import org.mule.weave.v2.module.http.undertow.ByteWriteChannelListener;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.util.ObjectValueUtils$;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.ssl.XnioSsl;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.ScalaNumericAnyConversions;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import spire.math.Number$;

public final class HttpRequestFunction$ {
    public static HttpRequestFunction$ MODULE$;
    private final String REQUEST_PAYLOAD_KEY;
    private final String METHOD_KEY;
    private final String URL_KEY;
    private final DefaultByteBufferPool pool;
    private final String SENT_BODY_KEY;
    private final String RESPONSE_PAYLOAD_KEY;
    private final OptionMap.Builder builder;
    private final OptionMap DEFAULT_OPTIONS;
    private final Xnio xnio;
    private final XnioWorker xnioWorker;

    static {
        new HttpRequestFunction$();
    }

    public String REQUEST_PAYLOAD_KEY() {
        return this.REQUEST_PAYLOAD_KEY;
    }

    public String METHOD_KEY() {
        return this.METHOD_KEY;
    }

    public String URL_KEY() {
        return this.URL_KEY;
    }

    public DefaultByteBufferPool pool() {
        return this.pool;
    }

    public String SENT_BODY_KEY() {
        return this.SENT_BODY_KEY;
    }

    public String RESPONSE_PAYLOAD_KEY() {
        return this.RESPONSE_PAYLOAD_KEY;
    }

    public OptionMap.Builder builder() {
        return this.builder;
    }

    public OptionMap DEFAULT_OPTIONS() {
        return this.DEFAULT_OPTIONS;
    }

    public Xnio xnio() {
        return this.xnio;
    }

    public XnioWorker xnioWorker() {
        return this.xnioWorker;
    }

    public WeaveFunction1 fun() {
        return (ctx, value1) -> {
            EvaluationContext implicitCtx = ctx;
            Seq resultKeys = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            ObjectRef responseKeys = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            ObjectRef requestKeys = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            ObjectRef timers = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            System.nanoTime();
            long initialTimer = System.nanoTime();
            LongRef checkpointTimer = LongRef.create((long)initialTimer);
            Value materializedRequestObject = ObjectType$.MODULE$.coerce(value1, implicitCtx).materialize(implicitCtx);
            try {
                String string;
                String string2;
                ObjectSeq requestObject = (ObjectSeq)materializedRequestObject.evaluate(implicitCtx);
                try {
                    string2 = ((String)StringType$.MODULE$.coerce(((KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply(MODULE$.METHOD_KEY()), implicitCtx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply(MODULE$.METHOD_KEY()), (Value)StringValue$.MODULE$.apply("GET"))))._2(), implicitCtx).evaluate(implicitCtx)).toUpperCase();
                }
                catch (Throwable e) {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.", " must be a String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.METHOD_KEY()})), e);
                }
                String method = string2;
                try {
                    string = (String)StringType$.MODULE$.coerce(((KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply(MODULE$.URL_KEY()), implicitCtx).get())._2(), implicitCtx).evaluate(implicitCtx);
                }
                catch (Throwable e) {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.", " must be a String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.URL_KEY()})), e);
                }
                String url = string;
                URI uri = URI.create(url);
                boolean isSSL = url.startsWith("https:");
                UndertowClient client = UndertowClient.getInstance();
                Option payloadContent = requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply(MODULE$.REQUEST_PAYLOAD_KEY()), implicitCtx);
                boolean hasPayload = payloadContent.isDefined();
                int readTimeout = MODULE$.getRequestTimeout(requestObject, "readTimeout", Predef$.MODULE$.int2Integer(30000), implicitCtx);
                int connectionTimeout = MODULE$.getRequestTimeout(requestObject, "connTimeout", Predef$.MODULE$.int2Integer(10000), implicitCtx);
                KeyValuePair compress = (KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("allowCompression"), implicitCtx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply("allowCompression"), (Value)BooleanValue$.MODULE$.apply(true, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())));
                Value value = HttpRequestFunction$.liftedTree1$1(implicitCtx, compress);
                boolean compress2 = BoxesRunTime.unboxToBoolean((Object)value.evaluate(implicitCtx));
                ClientRequest httpRequest = new ClientRequest();
                HttpString httpVersion = Protocols.HTTP_1_1;
                String sentUrl = url.replaceFirst(uri.getScheme() + "://" + uri.getAuthority(), "");
                requestKeys.elem = (Seq)((Seq)requestKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("httpVersion"), (Value)StringValue$.MODULE$.apply(httpVersion.toString())), Seq$.MODULE$.canBuildFrom());
                requestKeys.elem = (Seq)((Seq)requestKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("url"), (Value)StringValue$.MODULE$.apply(uri.toURL().toString())), Seq$.MODULE$.canBuildFrom());
                requestKeys.elem = (Seq)((Seq)requestKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("sentUrl"), (Value)StringValue$.MODULE$.apply(sentUrl)), Seq$.MODULE$.canBuildFrom());
                requestKeys.elem = (Seq)((Seq)requestKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("method"), (Value)StringValue$.MODULE$.apply(method)), Seq$.MODULE$.canBuildFrom());
                httpRequest.setMethod(HttpString.tryFromString((String)method));
                httpRequest.setProtocol(httpVersion);
                httpRequest.setPath(sentUrl);
                HeaderMap requestHeaders = httpRequest.getRequestHeaders();
                Option maybeRequestHeaders = requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("headers"), implicitCtx);
                if (maybeRequestHeaders.isDefined()) {
                    Value maybeRequestHeadersObject = HttpRequestFunction$.liftedTree2$1(implicitCtx, maybeRequestHeaders);
                    ((ObjectSeq)maybeRequestHeadersObject.evaluate(implicitCtx)).toIterator(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)kvpv -> {
                        Option values;
                        block0: {
                            QualifiedName key = (QualifiedName)kvpv._1().evaluate(implicitCtx);
                            String keyString = key.name();
                            values = ((ObjectSeq)maybeRequestHeadersObject.evaluate(implicitCtx)).allKeyValuesOf(kvpv._1(), implicitCtx);
                            if (!values.isDefined()) break block0;
                            ((ObjectSeq)values.get()).toSeq(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)value -> {
                                HttpString httpString;
                                String string;
                                try {
                                    string = (String)StringType$.MODULE$.coerce(value._2(), implicitCtx).evaluate(implicitCtx);
                                }
                                catch (Throwable e) {
                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid header value `", "`. It must be a String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyString})), e);
                                }
                                String headerValue = string;
                                try {
                                    httpString = HttpString.tryFromString((String)keyString);
                                }
                                catch (Throwable e) {
                                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid header name: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyString})), e);
                                }
                                HttpString headerName = httpString;
                                return requestHeaders.put(headerName, headerValue);
                            });
                        }
                        return values;
                    });
                }
                Object object = !requestHeaders.contains(Headers.HOST) ? requestHeaders.put(Headers.HOST, uri.getHost()) : BoxedUnit.UNIT;
                Object object2 = !requestHeaders.contains(Headers.CONNECTION) ? requestHeaders.put(Headers.CONNECTION, "close") : BoxedUnit.UNIT;
                Object object3 = !requestHeaders.contains(Headers.ACCEPT_ENCODING) && compress2 ? requestHeaders.put(Headers.ACCEPT_ENCODING, "gzip,deflate") : BoxedUnit.UNIT;
                if (hasPayload && !requestHeaders.contains("Content-Length") && !requestHeaders.contains("Transfer-Encoding")) {
                    throw new Exception("You can only send a payload if you specify either Content-Length or Transfer-Encoding headers");
                }
                Option maybeRequestCookies = requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("cookies"), implicitCtx);
                if (maybeRequestCookies.isDefined()) {
                    Value maybeRequestCookiesObject = HttpRequestFunction$.liftedTree3$1(implicitCtx, maybeRequestCookies);
                    ((ObjectSeq)maybeRequestCookiesObject.evaluate(implicitCtx)).toIterator(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)kvpv -> {
                        Option values;
                        block0: {
                            QualifiedName key = (QualifiedName)kvpv._1().evaluate(implicitCtx);
                            String keyString = key.name();
                            values = ((ObjectSeq)maybeRequestCookiesObject.evaluate(implicitCtx)).allKeyValuesOf(kvpv._1(), implicitCtx);
                            if (!values.isDefined()) break block0;
                            ((ObjectSeq)values.get()).toSeq(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)value -> {
                                String headerValue = (String)StringType$.MODULE$.coerce(value._2(), implicitCtx).evaluate(implicitCtx);
                                return requestHeaders.put(Headers.COOKIE, keyString + "=" + headerValue);
                            });
                        }
                        return values;
                    });
                }
                ClientRequest undertowClientRequest = httpRequest;
                HttpRequestFunction$.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$registerTimer$1("blocked", timers, checkpointTimer);
                ObjectRef connection = ObjectRef.create(null);
                try {
                    UndertowXnioSsl ssl;
                    InetAddress inetAddress;
                    try {
                        inetAddress = InetAddress.getByName(uri.getHost());
                    }
                    catch (UnknownHostException e) {
                        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot resolve host ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uri.getHost()})), e);
                    }
                    InetAddress address = inetAddress;
                    double dnsTime = (double)(System.nanoTime() - initialTimer) / 1000000.0;
                    if (dnsTime > 1.0) {
                        timers.elem = (Seq)((Seq)timers.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("dns"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(dnsTime))), Seq$.MODULE$.canBuildFrom());
                    }
                    SSLContext sslContext = MODULE$.getClientSSLContext(ObjectValueUtils$.MODULE$.select(requestObject, "sslOptions", implicitCtx), implicitCtx);
                    UndertowXnioSsl undertowXnioSsl = ssl = isSSL ? new UndertowXnioSsl(MODULE$.xnio(), OptionMap.EMPTY, (ByteBufferPool)MODULE$.pool(), sslContext) : null;
                    int port = uri.getPort() == -1 ? (ssl == null ? 80 : 443) : uri.getPort();
                    InetSocketAddress inetAddress2 = new InetSocketAddress(address, port);
                    requestKeys.elem = (Seq)((Seq)requestKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("ip"), (Value)StringValue$.MODULE$.apply(inetAddress2.getAddress().getHostAddress())), Seq$.MODULE$.canBuildFrom());
                    requestKeys.elem = (Seq)((Seq)requestKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("port"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(port))), Seq$.MODULE$.canBuildFrom());
                    String protocol = isSSL ? "https://" : "http://";
                    String path = uri.getPath().isEmpty() ? "/" : uri.getPath();
                    URI nuri = URI.create(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{protocol, address.getHostAddress(), BoxesRunTime.boxToInteger((int)port)})));
                    Promise connectionFuture = Promise$.MODULE$.apply();
                    client.connect((ClientCallback)new ClientCallback<ClientConnection>(timers, checkpointTimer, connectionFuture){
                        private final ObjectRef timers$1;
                        private final LongRef checkpointTimer$1;
                        private final Promise connectionFuture$1;

                        public void failed(IOException e) {
                            this.connectionFuture$1.failure((Throwable)e);
                        }

                        public void completed(ClientConnection result) {
                            if (result.isOpen()) {
                                HttpRequestFunction$.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$registerTimer$1("connect", this.timers$1, this.checkpointTimer$1);
                                this.connectionFuture$1.success((Object)result);
                            } else {
                                this.connectionFuture$1.failure((Throwable)new Exception("Error when establishing the connection"));
                            }
                        }
                        {
                            this.timers$1 = timers$1;
                            this.checkpointTimer$1 = checkpointTimer$1;
                            this.connectionFuture$1 = connectionFuture$1;
                        }
                    }, nuri, MODULE$.xnioWorker(), (XnioSsl)ssl, (ByteBufferPool)MODULE$.pool(), OptionMap.EMPTY);
                    connection.elem = (ClientConnection)Await$.MODULE$.result((Awaitable)connectionFuture.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(connectionTimeout)).milliseconds());
                    CompletableFuture future = new CompletableFuture();
                    ((ClientConnection)connection.elem).getIoThread().execute(() -> {
                        if (!((ClientConnection)connection$1.elem).isOpen()) {
                            future.completeExceptionally(new Error("The connection has been lost before sending the request"));
                        } else {
                            ((ClientConnection)connection$1.elem).sendRequest(undertowClientRequest, (ClientCallback)new ClientCallback<ClientExchange>(implicitCtx, responseKeys, requestKeys, timers, checkpointTimer, payloadContent, hasPayload, compress2, future){
                                public final EvaluationContext implicitCtx$1;
                                public final ObjectRef responseKeys$1;
                                private final ObjectRef requestKeys$1;
                                public final ObjectRef timers$1;
                                public final LongRef checkpointTimer$1;
                                private final Option payloadContent$1;
                                private final boolean hasPayload$1;
                                public final boolean compress$1;
                                public final CompletableFuture future$1;

                                public void completed(ClientExchange result) {
                                    HttpRequestFunction$.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$registerTimer$1("wait", this.timers$1, this.checkpointTimer$1);
                                    Seq headersSeq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                                    for (HeaderValues header : result.getRequest().getRequestHeaders()) {
                                        Iterator values = header.iterator();
                                        while (values.hasNext()) {
                                            headersSeq = (Seq)headersSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(header.getHeaderName().toString()), (Value)StringValue$.MODULE$.apply((String)values.next())), Seq$.MODULE$.canBuildFrom());
                                        }
                                    }
                                    ObjectValue requestHeadersObjectValue = ObjectValue$.MODULE$.apply(headersSeq, (LocationCapable)UnknownLocationCapable$.MODULE$);
                                    this.requestKeys$1.elem = (Seq)((Seq)this.requestKeys$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("headers"), (Value)requestHeadersObjectValue), Seq$.MODULE$.canBuildFrom());
                                    if (this.hasPayload$1) {
                                        this.requestKeys$1.elem = (Seq)((Seq)this.requestKeys$1.elem).$colon$plus((Object)HttpRequestFunction$.MODULE$.sendPayload(((KeyValuePair)this.payloadContent$1.get())._2(), result.getRequestChannel(), this.implicitCtx$1), Seq$.MODULE$.canBuildFrom());
                                    }
                                    result.setResponseListener((ClientCallback)new ClientCallback<ClientExchange>(this){
                                        private final /* synthetic */ anon.3 $outer;

                                        public void completed(ClientExchange result) {
                                            ClientResponse response = result.getResponse();
                                            this.$outer.responseKeys$1.elem = (Seq)((Seq)this.$outer.responseKeys$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("status"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(response.getResponseCode()))), Seq$.MODULE$.canBuildFrom());
                                            this.$outer.responseKeys$1.elem = (Seq)((Seq)this.$outer.responseKeys$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("statusText"), (Value)StringValue$.MODULE$.apply(response.getStatus())), Seq$.MODULE$.canBuildFrom());
                                            Seq headersSeq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                                            for (HeaderValues header : response.getResponseHeaders()) {
                                                Iterator values = header.iterator();
                                                while (values.hasNext()) {
                                                    headersSeq = (Seq)headersSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(header.getHeaderName().toString()), (Value)StringValue$.MODULE$.apply((String)values.next())), Seq$.MODULE$.canBuildFrom());
                                                }
                                                if (!header.getHeaderName().equalToString("Set-Cookie")) continue;
                                                this.$outer.responseKeys$1.elem = (Seq)((Seq)this.$outer.responseKeys$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("cookies"), (Value)HttpRequestFunction$.MODULE$.parseCookies(header, this.$outer.implicitCtx$1)), Seq$.MODULE$.canBuildFrom());
                                            }
                                            ObjectValue responseHeadersObjectValue = ObjectValue$.MODULE$.apply(headersSeq, (LocationCapable)UnknownLocationCapable$.MODULE$);
                                            this.$outer.responseKeys$1.elem = (Seq)((Seq)this.$outer.responseKeys$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("headers"), (Value)responseHeadersObjectValue), Seq$.MODULE$.canBuildFrom());
                                            new ByteReadChannelListener(this, result, response){
                                                private final /* synthetic */ anon$3$$anon$4 $outer;
                                                private final ClientResponse response$1;

                                                public void bytesDone(byte[] bytes) {
                                                    HttpRequestFunction$.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$registerTimer$1("receive", this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().timers$1, this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().checkpointTimer$1);
                                                    if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).nonEmpty()) {
                                                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                                        String encoding = (String)Option$.MODULE$.apply((Object)this.response$1.getResponseHeaders().get(Headers.CONTENT_ENCODING)).map((Function1 & Serializable & scala.Serializable)x -> x.getFirst()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                                                        this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().responseKeys$1.elem = (Seq)((Seq)this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().responseKeys$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(HttpRequestFunction$.MODULE$.RESPONSE_PAYLOAD_KEY()), (Value)BinaryValue$.MODULE$.apply(HttpRequestFunction$.MODULE$.decompressGzip(bis, this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().compress$1, encoding))), Seq$.MODULE$.canBuildFrom());
                                                    }
                                                    this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().future$1.complete(BoxesRunTime.boxToBoolean((boolean)true));
                                                }

                                                public void error(IOException e) {
                                                    this.$outer.org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer().future$1.completeExceptionally(e);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.response$1 = response$1;
                                                    super(result$1.getConnection().getBufferPool());
                                                }

                                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$bytesDone$1(io.undertow.util.HeaderValues ), $anonfun$bytesDone$2()}, serializedLambda);
                                                }
                                            }.setup(result.getResponseChannel());
                                        }

                                        public void failed(IOException e) {
                                            this.$outer.future$1.completeExceptionally(e);
                                        }

                                        public /* synthetic */ anon.3 org$mule$weave$v2$module$http$functions$HttpRequestFunction$$anon$$anon$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    try {
                                        result.getRequestChannel().shutdownWrites();
                                        if (!result.getRequestChannel().flush()) {
                                            result.getRequestChannel().getWriteSetter().set(ChannelListeners.flushingChannelListener(null, null));
                                            result.getRequestChannel().resumeWrites();
                                        }
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        this.future$1.completeExceptionally(e);
                                    }
                                }

                                public void failed(IOException e) {
                                    this.future$1.completeExceptionally(e);
                                }
                                {
                                    this.implicitCtx$1 = implicitCtx$1;
                                    this.responseKeys$1 = responseKeys$1;
                                    this.requestKeys$1 = requestKeys$1;
                                    this.timers$1 = timers$1;
                                    this.checkpointTimer$1 = checkpointTimer$1;
                                    this.payloadContent$1 = payloadContent$1;
                                    this.hasPayload$1 = hasPayload$1;
                                    this.compress$1 = compress$1;
                                    this.future$1 = future$1;
                                }
                            });
                        }
                    });
                    ctx.registerCloseable((AutoCloseable)((ClientConnection)connection.elem));
                    future.get(readTimeout, TimeUnit.MILLISECONDS);
                }
                finally {
                    timers.elem = (Seq)((Seq)timers.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("total"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply((double)(System.nanoTime() - initialTimer) / 1000000.0))), Seq$.MODULE$.canBuildFrom());
                    IoUtils.safeClose((Closeable)((ClientConnection)connection.elem));
                }
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("err"), (Value)BooleanValue$.MODULE$.apply(false, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
            }
            catch (Throwable e) {
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("err"), (Value)BooleanValue$.MODULE$.apply(true, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("message"), (Value)StringValue$.MODULE$.apply((String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> e.getClass().getSimpleName()))), Seq$.MODULE$.canBuildFrom());
            }
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("options"), materializedRequestObject), Seq$.MODULE$.canBuildFrom());
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("request"), (Value)ObjectValue$.MODULE$.apply((Seq)requestKeys.elem, (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("response"), (Value)ObjectValue$.MODULE$.apply((Seq)responseKeys.elem, (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("timers"), (Value)ObjectValue$.MODULE$.apply((Seq)timers.elem, (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            return ObjectValue$.MODULE$.apply(resultKeys, (LocationCapable)UnknownLocationCapable$.MODULE$);
        };
    }

    public int getRequestTimeout(ObjectSeq obj, String key, Number number, EvaluationContext ctx) {
        Value value;
        KeyValuePair timeoutKVP = (KeyValuePair)obj.keyValueOf((Value)KeyValue$.MODULE$.apply(key), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply(key), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(30000))));
        try {
            value = NumberType$.MODULE$.coerce(timeoutKVP._2(), ctx);
        }
        catch (Throwable e) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.", " must be a Number > 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), e);
        }
        Value value2 = value;
        int timeout = ((ScalaNumericAnyConversions)value2.evaluate(ctx)).toInt();
        if (timeout <= 0) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.", " must be > 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        }
        return timeout;
    }

    public InputStream decompressGzip(InputStream inputStream, boolean compress, String contentEncoding) {
        boolean shouldDecompress;
        boolean bl = shouldDecompress = compress && inputStream != null;
        return shouldDecompress && contentEncoding.contains("gzip") ? new GZIPInputStream(inputStream) : (shouldDecompress && contentEncoding.contains("deflate") ? new InflaterInputStream(inputStream) : inputStream);
    }

    public KeyValuePair sendPayload(Value<?> value, StreamSinkChannel channel, EvaluationContext ctx) {
        if (!BinaryType$.MODULE$.accepts(value, ctx)) {
            throw new Exception("Cannot coerce request.payload to Binary");
        }
        SeekableStream bodyToSend = (SeekableStream)BinaryType$.MODULE$.coerce(value, ctx).evaluate(ctx);
        byte[] bytes = BinaryValue$.MODULE$.getBytesFromSeekableStream(bodyToSend, BinaryValue$.MODULE$.getBytesFromSeekableStream$default$2());
        new ByteWriteChannelListener(ByteBuffer.wrap(bytes)).setup(channel);
        return new KeyValuePair((Value)KeyValue$.MODULE$.apply(this.SENT_BODY_KEY()), (Value)BinaryValue$.MODULE$.apply((InputStream)bodyToSend, (LocationCapable)UnknownLocationCapable$.MODULE$));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLContext getClientSSLContext(Option<Value<?>> sslOptions, EvaluationContext ctx) {
        SSLContext sSLContext;
        String string;
        char[] cArray;
        SeekableStream seekableStream;
        ObjectSeq objectSeq;
        try {
            Value sslOptionsObject = (Value)sslOptions.getOrElse((Function0 & Serializable & scala.Serializable)() -> ObjectValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            objectSeq = (ObjectSeq)ObjectType$.MODULE$.coerce(sslOptionsObject, ctx).evaluate(ctx);
        }
        catch (Throwable e) {
            throw new Exception("sslOptions must be an object", e);
        }
        ObjectSeq options = objectSeq;
        Value cert = (Value)ObjectValueUtils$.MODULE$.select(options, "cert", ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullValue$.MODULE$);
        Value password = (Value)ObjectValueUtils$.MODULE$.select(options, "password", ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullValue$.MODULE$);
        Value keyStoreTypeValue = (Value)ObjectValueUtils$.MODULE$.select(options, "keyStoreTypeValue", ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> NullValue$.MODULE$);
        try {
            seekableStream = NullType$.MODULE$.accepts(cert, ctx) ? null : (SeekableStream)BinaryType$.MODULE$.coerce(cert, ctx).evaluate(ctx);
        }
        catch (Throwable e) {
            throw new Exception("sslOptions.cert must be a String or Binary or Null", e);
        }
        SeekableStream is = seekableStream;
        try {
            cArray = NullType$.MODULE$.accepts(password, ctx) ? null : ((String)StringType$.MODULE$.coerce(password, ctx).evaluate(ctx)).toCharArray();
        }
        catch (Throwable e) {
            throw new Exception("sslOptions.password must be a String or Binary or Null", e);
        }
        char[] pass = cArray;
        try {
            string = NullType$.MODULE$.accepts(keyStoreTypeValue, ctx) ? "JKS" : (String)StringType$.MODULE$.coerce(keyStoreTypeValue, ctx).evaluate(ctx);
        }
        catch (Throwable e) {
            throw new Exception("sslOptions.keyStoreType must be \"JKS\" or \"PKCS12\"", e);
        }
        String keyStoreType = string;
        if (is == null && pass == null) {
            String string2 = keyStoreType;
            String string3 = "JKS";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                sSLContext = SSLContext.getDefault();
                return sSLContext;
            }
        }
        KeyStore loadedKeystore = KeyStore.getInstance(keyStoreType);
        loadedKeystore.load((InputStream)is, pass);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(loadedKeystore, pass);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        sSLContext = context;
        return sSLContext;
    }

    public ObjectValue parseCookies(HeaderValues header, EvaluationContext ctx) {
        Iterator values = header.iterator();
        Seq cookiesSeq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (values.hasNext()) {
            String value = (String)values.next();
            Cookie cookie = Cookies.parseSetCookieHeader((String)value);
            Seq cookieObjectSeq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (cookie.getName() != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("name"), (Value)StringValue$.MODULE$.apply(cookie.getName())), Seq$.MODULE$.canBuildFrom());
            }
            if (cookie.getValue() != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("value"), (Value)StringValue$.MODULE$.apply(cookie.getValue())), Seq$.MODULE$.canBuildFrom());
            }
            if (cookie.getDomain() != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("domain"), (Value)StringValue$.MODULE$.apply(cookie.getDomain())), Seq$.MODULE$.canBuildFrom());
            }
            if (cookie.getComment() != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("comment"), (Value)StringValue$.MODULE$.apply(cookie.getComment())), Seq$.MODULE$.canBuildFrom());
            }
            if (cookie.getPath() != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("path"), (Value)StringValue$.MODULE$.apply(cookie.getPath())), Seq$.MODULE$.canBuildFrom());
            }
            if (cookie.getMaxAge() != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("maxAge"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(cookie.getMaxAge().intValue()))), Seq$.MODULE$.canBuildFrom());
            }
            if (BoxesRunTime.boxToBoolean((boolean)cookie.isHttpOnly()) != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("httpOnly"), (Value)BooleanValue$.MODULE$.apply(cookie.isHttpOnly(), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
            }
            if (BoxesRunTime.boxToBoolean((boolean)cookie.isHttpOnly()) != null) {
                cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("secure"), (Value)BooleanValue$.MODULE$.apply(!cookie.isHttpOnly(), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
            }
            cookiesSeq = (Seq)cookiesSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(cookie.getName()), (Value)ObjectValue$.MODULE$.apply(cookieObjectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
        }
        return ObjectValue$.MODULE$.apply(cookiesSeq, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public Function1Value apply() {
        return new Function1Value(this.fun(), new FunctionParameter("request", (Type)ObjectType$.MODULE$, FunctionParameter$.MODULE$.apply$default$3()));
    }

    public static final void org$mule$weave$v2$module$http$functions$HttpRequestFunction$$registerTimer$1(String name, ObjectRef timers$1, LongRef checkpointTimer$1) {
        long now = System.nanoTime();
        timers$1.elem = (Seq)((Seq)timers$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(name), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply((double)(now - checkpointTimer$1.elem) / 1000000.0))), Seq$.MODULE$.canBuildFrom());
        checkpointTimer$1.elem = now;
    }

    private static final Value liftedTree1$1(EvaluationContext implicitCtx$1, KeyValuePair compress$2) {
        Value value;
        try {
            value = BooleanType$.MODULE$.coerce(compress$2._2(), implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception("request.allowCompression must be a Boolean", e);
        }
        return value;
    }

    private static final Value liftedTree2$1(EvaluationContext implicitCtx$1, Option maybeRequestHeaders$1) {
        Value value;
        try {
            value = ObjectType$.MODULE$.coerce(((KeyValuePair)maybeRequestHeaders$1.get())._2(), implicitCtx$1).materialize(implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception("request.headers must be an Object", e);
        }
        return value;
    }

    private static final Value liftedTree3$1(EvaluationContext implicitCtx$1, Option maybeRequestCookies$1) {
        Value value;
        try {
            value = ObjectType$.MODULE$.coerce(((KeyValuePair)maybeRequestCookies$1.get())._2(), implicitCtx$1).materialize(implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception("request.cookies must be an Object", e);
        }
        return value;
    }

    private HttpRequestFunction$() {
        MODULE$ = this;
        this.REQUEST_PAYLOAD_KEY = "body";
        this.METHOD_KEY = "method";
        this.URL_KEY = "url";
        this.pool = new DefaultByteBufferPool(true, 17408, -1, 12);
        this.SENT_BODY_KEY = "payload";
        this.RESPONSE_PAYLOAD_KEY = "payload";
        this.builder = OptionMap.builder().set(Options.WORKER_IO_THREADS, 8).set(Options.TCP_NODELAY, true).set(Options.SSL_USE_CLIENT_MODE, true).set(Options.WORKER_NAME, (Object)"DataWeave");
        this.DEFAULT_OPTIONS = this.builder().getMap();
        this.xnio = Xnio.getInstance();
        this.xnioWorker = this.xnio().createWorker(null, this.DEFAULT_OPTIONS());
    }
}

