/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.undertow;

import io.undertow.io.IoCallback;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.util.Map;
import org.mule.weave.v2.module.http.service.HttpRequest;
import org.mule.weave.v2.module.http.service.HttpResponse;
import org.mule.weave.v2.module.http.undertow.ChunkedStream;
import org.mule.weave.v2.module.http.undertow.ChunkedStream$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001#\t)RK\u001c3feR|woU3sm\u0016\u0014\b*\u00198eY\u0016\u0014(BA\u0002\u0005\u0003!)h\u000eZ3si><(BA\u0003\u0007\u0003\u0011AG\u000f\u001e9\u000b\u0005\u001dA\u0011AB7pIVdWM\u0003\u0002\n\u0015\u0005\u0011aO\r\u0006\u0003\u00171\tQa^3bm\u0016T!!\u0004\b\u0002\t5,H.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\u000e\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001\u00027b]\u001eT\u0011aF\u0001\u0005U\u00064\u0018-\u0003\u0002\u001a)\t1qJ\u00196fGR\u0004\"aG\u0011\u000e\u0003qQ!!\b\u0010\u0002\rM,'O^3s\u0015\t\u0019qDC\u0001!\u0003\tIw.\u0003\u0002#9\tY\u0001\n\u001e;q\u0011\u0006tG\r\\3s\u0011!!\u0003A!A!\u0002\u0013)\u0013\u0001C2bY2\u0014\u0017mY6\u0011\t\u0019J3&M\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\tIa)\u001e8di&|g.\r\t\u0003Y=j\u0011!\f\u0006\u0003]\u0011\tqa]3sm&\u001cW-\u0003\u00021[\tY\u0001\n\u001e;q%\u0016\fX/Z:u!\ta#'\u0003\u00024[\ta\u0001\n\u001e;q%\u0016\u001c\bo\u001c8tK\")Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"\"aN\u001d\u0011\u0005a\u0002Q\"\u0001\u0002\t\u000b\u0011\"\u0004\u0019A\u0013\t\u000bm\u0002A\u0011\t\u001f\u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u)\ti\u0004\t\u0005\u0002'}%\u0011qh\n\u0002\u0005+:LG\u000fC\u0003Bu\u0001\u0007!)\u0001\u0005fq\u000eD\u0017M\\4f!\tY2)\u0003\u0002E9\t\u0011\u0002\n\u001e;q'\u0016\u0014h/\u001a:Fq\u000eD\u0017M\\4f\u0011\u00151\u0005\u0001\"\u0003H\u00031\u0011W/\u001b7e%\u0016\fX/Z:u)\tY\u0003\nC\u0003B\u000b\u0002\u0007!\t")
public class UndertowServerHandler
implements HttpHandler {
    private final Function1<HttpRequest, HttpResponse> callback;

    public void handleRequest(HttpServerExchange exchange) {
        if (exchange.isInIoThread()) {
            HeaderValues upgrade = exchange.getRequestHeaders().get(Headers.UPGRADE);
            Object object = upgrade != null && upgrade.contains((Object)"h2c") ? exchange.setProtocol(Protocols.HTTP_1_1) : BoxedUnit.UNIT;
            exchange.dispatch((HttpHandler)this);
        } else {
            exchange.startBlocking();
            HttpRequest request = this.buildRequest(exchange);
            HttpResponse response = (HttpResponse)this.callback.apply((Object)request);
            exchange.setStatusCode(response.statusCode());
            response.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                HeaderMap headerMap = exchange.getResponseHeaders().add(new HttpString(key), value);
                return headerMap;
            });
            if (response.body() != null) {
                new ChunkedStream(ChunkedStream$.MODULE$.$lessinit$greater$default$1()).send(Channels.newChannel(response.body()), exchange, IoCallback.END_EXCHANGE);
            } else {
                exchange.endExchange();
            }
        }
    }

    private HttpRequest buildRequest(HttpServerExchange exchange) {
        InputStream body = exchange.getInputStream();
        HeaderMap requestMultiMap = exchange.getRequestHeaders();
        ArrayBuffer headers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        requestMultiMap.forEach(headerValue -> {
            HttpString headerName = headerValue.getHeaderName();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headerValue.toArray())).foreach((Function1 & Serializable & scala.Serializable)value -> headers.$plus$eq((Object)new Tuple2((Object)headerName.toString(), value)));
        });
        Map queryParametersMultiMap = exchange.getQueryParameters();
        ArrayBuffer queryParams = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryParametersMultiMap.forEach((name, queue) -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(queue.toArray())).foreach((Function1 & Serializable & scala.Serializable)value -> queryParams.$plus$eq((Object)new Tuple2(name, (Object)value.toString()))));
        String relativePath = exchange.getRelativePath();
        return new HttpRequest(body, relativePath, exchange.getRequestMethod().toString(), (Seq<Tuple2<String, String>>)headers, (Seq<Tuple2<String, String>>)queryParams);
    }

    public UndertowServerHandler(Function1<HttpRequest, HttpResponse> callback) {
        this.callback = callback;
    }
}

