type HttpResponseCookie = {
  name: String,
  value: String,
  domain: String,
  comment: String,
  path: String,
  maxAge: Number,
  httpOnly: Boolean,
  secure: Boolean
}

type HttpResponseCookies = {
  _ ?: HttpResponseCookie
}

type HttpHeaders = {
  _ ?: String
}

type HttpRequest = {
  /** Full url for the request, including domain */
  url: String,
  method: String
}

type OptionalHttpRequestOptions = {
  headers?: HttpHeaders,
  body?: Any,
  /** Do we accept header redirections? */
  allowRedirect?: Boolean,

  /** Accept self signed server certificates */
  allowUnsafeSSL?: Boolean,

  readTimeout?: Number, // default 20000ms
  connTimeout?: Number, // default 10000ms

  /** Should HTTP compression be used?
    * If true, Accept-Encoding: gzip,deflate will be sent with request.
    * If the server response with Content-Encoding: (gzip|deflate) the client will automatically handle decompression
    *
    * This is true by default
    */
  allowCompression?: Boolean
}


type ClientHttpRequest = HttpRequest & OptionalHttpRequestOptions

type HttpResponseResponse = {
                            /** Example: 200 */
                            status: Number,
                            /** Example: "OK" */
                            statusText: String,
                            /** Response headers **/
                            headers: HttpHeaders,
                            /** Response's raw body */
                            payload: Binary,
                            /** If we van parse the body response. */
                            body?: Any,
                            /** Get the parsed cookies from the "Set-Cookie" header **/
                            cookies: HttpResponseCookies,
                            /** Content type header */
                            contentType: String,
                            /** MIME type of the content type, without encoding */
                            mime: String
                          }

type HttpResponse = {
  err: Boolean,

  message?: String,

  options: Object,

  request: {
    httpVersion: String,

    /** Full url with domain and queryParameters. This may change with redirections */
    url: String,

    sentUrl: String,
    method: String,
    ip: String,
    port: Number,
    headers: HttpHeaders,
    payload?: Binary
  },

  /** Timing metrics, all values are accumulative except for ssl, it is included inside connect when available */
  timers?: {-|
    blocked?: Number, // Time spent in a queue waiting for a network connection.
    dns?: Number,     // DNS resolution time. The time required to resolve a host name.
    connect?: Number, // Time required to create TCP connection.
    send?: Number,    // Time required to send HTTP request to the server.
    wait?: Number,    // Waiting for a response from the server.
    receive?: Number, // Time required to read entire response from the server (or cache).
    ssl?: Number,     // Time required for SSL/TLS negotiation. If this field is defined then the time is also included in the connect field (to ensure backward compatibility with HAR 1.1).
    total: Number
  |-},

  response: HttpResponseResponse
}

