/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.functions;

import io.undertow.server.handlers.Cookie;
import io.undertow.util.Cookies;
import io.undertow.util.HttpString;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable$;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.ObjectSeq;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.Function1Value;
import org.mule.weave.v2.model.values.FunctionParameter;
import org.mule.weave.v2.model.values.FunctionParameter$;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.WeaveFunction1;
import org.mule.weave.v2.module.http.HttpHeader$;
import org.mule.weave.v2.module.http.client.JavaHttpClientService;
import org.mule.weave.v2.module.http.service.HttpClientOptions;
import org.mule.weave.v2.module.http.service.HttpClientOptions$;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.http.service.HttpClientResult;
import org.mule.weave.v2.module.http.service.HttpClientService;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.math.ScalaNumericAnyConversions;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import spire.math.Number$;

public final class HttpRequestFunction$ {
    public static HttpRequestFunction$ MODULE$;

    static {
        new HttpRequestFunction$();
    }

    public Value<?> responseToWeave(HttpClientResponse $, EvaluationContext ctx) {
        Seq responseKeys;
        block1: {
            responseKeys = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            responseKeys = (Seq)responseKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("status"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply($.status().intValue()))), Seq$.MODULE$.canBuildFrom());
            responseKeys = (Seq)responseKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("statusText"), (Value)StringValue$.MODULE$.apply(((String)$.statusText().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).replaceAll("HTTP/1.1 " + $.status().toString() + " ", ""))), Seq$.MODULE$.canBuildFrom());
            responseKeys = (Seq)responseKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("headers"), (Value)this.headersToWeave($.headers(), ctx)), Seq$.MODULE$.canBuildFrom());
            if ($.headers().contains((Object)"Set-Cookie")) {
                responseKeys = (Seq)responseKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("cookies"), (Value)this.parseCookies($.headerSeq("Set-Cookie"), ctx)), Seq$.MODULE$.canBuildFrom());
            }
            if (!$.payload().isDefined()) break block1;
            ctx.registerCloseable((AutoCloseable)$.payload().get());
            responseKeys = (Seq)responseKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("payload"), (Value)BinaryValue$.MODULE$.apply((InputStream)$.payload().get())), Seq$.MODULE$.canBuildFrom());
        }
        return ObjectValue$.MODULE$.apply(responseKeys, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public ObjectValue headersToWeave(Map<String, Seq<String>> headers, EvaluationContext ctx) {
        ObjectRef headersSeq = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        headers.foreach((Function1 & Serializable & scala.Serializable)tuple -> {
            HttpRequestFunction$.$anonfun$headersToWeave$1(headersSeq, tuple);
            return BoxedUnit.UNIT;
        });
        return ObjectValue$.MODULE$.apply((Seq)headersSeq.elem, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public ObjectValue parseCookies(Seq<String> cookieHeader, EvaluationContext ctx) {
        ObjectRef cookiesSeq = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        cookieHeader.foreach((Function1 & Serializable & scala.Serializable)value -> {
            HttpRequestFunction$.$anonfun$parseCookies$1(cookiesSeq, value);
            return BoxedUnit.UNIT;
        });
        return ObjectValue$.MODULE$.apply((Seq)cookiesSeq.elem, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public Value<?> requestToWeave(HttpClientRequest $, EvaluationContext ctx) {
        Seq requestKeys;
        block0: {
            requestKeys = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("httpVersion"), (Value)StringValue$.MODULE$.apply($.httpVersion())), Seq$.MODULE$.canBuildFrom());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("method"), (Value)StringValue$.MODULE$.apply($.method())), Seq$.MODULE$.canBuildFrom());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("url"), (Value)StringValue$.MODULE$.apply($.url())), Seq$.MODULE$.canBuildFrom());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("path"), (Value)StringValue$.MODULE$.apply($.path())), Seq$.MODULE$.canBuildFrom());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("ip"), (Value)StringValue$.MODULE$.apply($.ip())), Seq$.MODULE$.canBuildFrom());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("port"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(Predef$.MODULE$.int2Integer($.port()).intValue()))), Seq$.MODULE$.canBuildFrom());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("headers"), (Value)this.headersToWeave($.headers(), ctx)), Seq$.MODULE$.canBuildFrom());
            if (!$.payload().isDefined()) break block0;
            ctx.registerCloseable((AutoCloseable)$.payload().get());
            requestKeys = (Seq)requestKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("payload"), (Value)BinaryValue$.MODULE$.apply((InputStream)$.payload().get())), Seq$.MODULE$.canBuildFrom());
        }
        return ObjectValue$.MODULE$.apply(requestKeys, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public Value<?> timersToWeave(Map<String, Number> timers, EvaluationContext ctx) {
        ObjectRef timerKeys;
        block0: {
            timerKeys = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            timers.foreach((Function1 & Serializable & scala.Serializable)x -> {
                timerKeys.elem = (Seq)((Seq)timerKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply((String)x._1()), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(((Number)x._2()).floatValue()))), Seq$.MODULE$.canBuildFrom());
                return BoxedUnit.UNIT;
            });
            if (!timers.get((Object)"total").isEmpty()) break block0;
            timerKeys.elem = (Seq)((Seq)timerKeys.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("total"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(0))), Seq$.MODULE$.canBuildFrom());
        }
        return ObjectValue$.MODULE$.apply((Seq)timerKeys.elem, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public Value<?> resultToWeave(HttpClientResult $, Value<?> options, EvaluationContext ctx) {
        Seq resultKeys = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("options"), options), Seq$.MODULE$.canBuildFrom());
            if ($.request().isDefined()) {
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("request"), this.requestToWeave((HttpClientRequest)$.request().get(), ctx)), Seq$.MODULE$.canBuildFrom());
            }
            if ($.response().isDefined()) {
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("response"), this.responseToWeave((HttpClientResponse)$.response().get(), ctx)), Seq$.MODULE$.canBuildFrom());
            }
            if ($.timers().isDefined()) {
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("timers"), this.timersToWeave((Map<String, Number>)((Map)$.timers().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), ctx)), Seq$.MODULE$.canBuildFrom());
            }
            if ($.message().isDefined()) {
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("message"), (Value)StringValue$.MODULE$.apply((String)$.message().get(), (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            }
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("err"), (Value)BooleanValue$.MODULE$.apply($.err(), (LocationCapable)UnknownLocationCapable$.MODULE$, BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
        }
        catch (Throwable e) {
            e.printStackTrace();
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("err"), (Value)BooleanValue$.MODULE$.apply(true, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
            resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("message"), (Value)StringValue$.MODULE$.apply(e.toString(), (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
        }
        return ObjectValue$.MODULE$.apply(resultKeys, (LocationCapable)UnknownLocationCapable$.MODULE$);
    }

    public WeaveFunction1 fun() {
        return (ctx, value1) -> {
            Value<?> value;
            HttpClientService httpClientService = (HttpClientService)ctx.serviceManager().lookupCustomService(HttpClientService.class, (Function0 & Serializable & scala.Serializable)() -> new JavaHttpClientService());
            EvaluationContext implicitCtx = ctx;
            Value materializedRequestObject = ObjectType$.MODULE$.coerce(value1, implicitCtx).materialize(implicitCtx);
            HttpClientOptions options = null;
            try {
                Option maybeRequestCookies;
                String string;
                String string2;
                ObjectSeq requestObject = (ObjectSeq)materializedRequestObject.evaluate(implicitCtx);
                try {
                    string2 = ((String)StringType$.MODULE$.coerce(((KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("method"), implicitCtx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply("method"), (Value)StringValue$.MODULE$.apply("GET"))))._2(), implicitCtx).evaluate(implicitCtx)).toUpperCase();
                }
                catch (Throwable e) {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.method must be a String"})).s((Seq)Nil$.MODULE$), e);
                }
                String method = string2;
                try {
                    string = (String)StringType$.MODULE$.coerce(((KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("url"), implicitCtx).get())._2(), implicitCtx).evaluate(implicitCtx);
                }
                catch (Throwable e) {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.url must be a String"})).s((Seq)Nil$.MODULE$), e);
                }
                String url = string;
                options = new HttpClientOptions(url, method, HttpClientOptions$.MODULE$.apply$default$3(), HttpClientOptions$.MODULE$.apply$default$4(), HttpClientOptions$.MODULE$.apply$default$5(), HttpClientOptions$.MODULE$.apply$default$6(), HttpClientOptions$.MODULE$.apply$default$7(), HttpClientOptions$.MODULE$.apply$default$8(), HttpClientOptions$.MODULE$.apply$default$9(), HttpClientOptions$.MODULE$.apply$default$10(), HttpClientOptions$.MODULE$.apply$default$11());
                Option payloadContent = requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("body"), implicitCtx);
                boolean hasPayload = payloadContent.isDefined();
                if (hasPayload) {
                    if (!BinaryType$.MODULE$.accepts(((KeyValuePair)payloadContent.get())._2(), implicitCtx)) {
                        throw new Exception("Cannot coerce request.payload to Binary");
                    }
                    options.body_$eq((Option<InputStream>)new Some(BinaryType$.MODULE$.coerce(((KeyValuePair)payloadContent.get())._2(), implicitCtx).evaluate(implicitCtx)));
                }
                options.readTimeout_$eq(Predef$.MODULE$.int2Integer(MODULE$.getRequestTimeout(requestObject, "readTimeout", Predef$.MODULE$.int2Integer(30000), implicitCtx)));
                options.connectionTimeout_$eq(Predef$.MODULE$.int2Integer(MODULE$.getRequestTimeout(requestObject, "connectionTimeout", Predef$.MODULE$.int2Integer(10000), implicitCtx)));
                KeyValuePair compress = (KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("allowCompression"), implicitCtx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply("allowCompression"), (Value)BooleanValue$.MODULE$.apply(true, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())));
                Value value2 = HttpRequestFunction$.liftedTree1$1(implicitCtx, compress);
                options.allowCompression_$eq(BoxesRunTime.unboxToBoolean((Object)value2.evaluate(implicitCtx)));
                options.allowRedirect_$eq(BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(((KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("allowRedirect"), implicitCtx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply("allowRedirect"), (Value)BooleanValue$.MODULE$.apply(false, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3()))))._2(), implicitCtx).evaluate(implicitCtx)));
                options.ssl().allowSelfSignedCertificate_$eq(BoxesRunTime.unboxToBoolean((Object)BooleanType$.MODULE$.coerce(((KeyValuePair)requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("allowUnsafeSSL"), implicitCtx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply("allowUnsafeSSL"), (Value)BooleanValue$.MODULE$.apply(false, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3()))))._2(), implicitCtx).evaluate(implicitCtx)));
                Option maybeRequestHeaders = requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("headers"), implicitCtx);
                scala.collection.mutable.Map requestHeaders = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                if (maybeRequestHeaders.isDefined()) {
                    Value maybeRequestHeadersObject = HttpRequestFunction$.liftedTree2$1(implicitCtx, maybeRequestHeaders);
                    ((ObjectSeq)maybeRequestHeadersObject.evaluate(implicitCtx)).toIterator(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)kvpv -> {
                        HttpRequestFunction$.$anonfun$fun$7(implicitCtx, requestHeaders, maybeRequestHeadersObject, kvpv);
                        return BoxedUnit.UNIT;
                    });
                }
                if ((maybeRequestCookies = requestObject.keyValueOf((Value)KeyValue$.MODULE$.apply("cookies"), implicitCtx)).isDefined()) {
                    Value maybeRequestCookiesObject = HttpRequestFunction$.liftedTree3$1(implicitCtx, maybeRequestCookies);
                    ((ObjectSeq)maybeRequestCookiesObject.evaluate(implicitCtx)).toIterator(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)kvpv -> {
                        Option values;
                        block0: {
                            QualifiedName key = (QualifiedName)kvpv._1().evaluate(implicitCtx);
                            String keyString = key.name();
                            values = ((ObjectSeq)maybeRequestCookiesObject.evaluate(implicitCtx)).allKeyValuesOf(kvpv._1(), implicitCtx);
                            if (!values.isDefined()) break block0;
                            ((ObjectSeq)values.get()).toSeq(implicitCtx).foreach((Function1 & Serializable & scala.Serializable)value -> {
                                HttpRequestFunction$.$anonfun$fun$11(implicitCtx, requestHeaders, keyString, value);
                                return BoxedUnit.UNIT;
                            });
                        }
                        return values;
                    });
                }
                options.headers_$eq((Map<String, Seq<String>>)requestHeaders.toMap(Predef$.MODULE$.$conforms()));
                HttpClientResult result = httpClientService.request(options);
                value = MODULE$.resultToWeave(result, materializedRequestObject, implicitCtx);
            }
            catch (Throwable e) {
                Seq resultKeys = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("err"), (Value)BooleanValue$.MODULE$.apply(true, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
                resultKeys = (Seq)resultKeys.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("message"), (Value)StringValue$.MODULE$.apply((String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> e.getClass().getSimpleName()))), Seq$.MODULE$.canBuildFrom());
                value = ObjectValue$.MODULE$.apply(resultKeys, (LocationCapable)UnknownLocationCapable$.MODULE$);
            }
            return value;
        };
    }

    public int getRequestTimeout(ObjectSeq obj, String key, Number number, EvaluationContext ctx) {
        Value value;
        KeyValuePair timeoutKVP = (KeyValuePair)obj.keyValueOf((Value)KeyValue$.MODULE$.apply(key), ctx).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KeyValuePair((Value)KeyValue$.MODULE$.apply(key), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(30000))));
        try {
            value = NumberType$.MODULE$.coerce(timeoutKVP._2(), ctx);
        }
        catch (Throwable e) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.", " must be a Number > 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), e);
        }
        Value value2 = value;
        int timeout = ((ScalaNumericAnyConversions)value2.evaluate(ctx)).toInt();
        if (timeout <= 0) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request.", " must be > 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        }
        return timeout;
    }

    public Function1Value apply() {
        return new Function1Value(this.fun(), new FunctionParameter("request", (Type)ObjectType$.MODULE$, FunctionParameter$.MODULE$.apply$default$3()));
    }

    public static final /* synthetic */ void $anonfun$headersToWeave$1(ObjectRef headersSeq$1, Tuple2 tuple) {
        ((IterableLike)tuple._2()).foreach((Function1 & Serializable & scala.Serializable)value -> {
            headersSeq$1.elem = (Seq)((Seq)headersSeq$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply((String)tuple._1()), (Value)StringValue$.MODULE$.apply(value)), Seq$.MODULE$.canBuildFrom());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$parseCookies$1(ObjectRef cookiesSeq$1, String value) {
        Cookie cookie = Cookies.parseSetCookieHeader((String)value);
        Seq cookieObjectSeq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (cookie.getName() != null) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("name"), (Value)StringValue$.MODULE$.apply(cookie.getName())), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.getValue() != null) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("value"), (Value)StringValue$.MODULE$.apply(cookie.getValue())), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.getDomain() != null) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("domain"), (Value)StringValue$.MODULE$.apply(cookie.getDomain())), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.getComment() != null) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("comment"), (Value)StringValue$.MODULE$.apply(cookie.getComment())), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.getPath() != null) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("path"), (Value)StringValue$.MODULE$.apply(cookie.getPath())), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.getMaxAge() != null) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("maxAge"), (Value)NumberValue$.MODULE$.apply(Number$.MODULE$.apply(cookie.getMaxAge().intValue()))), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.isHttpOnly()) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("httpOnly"), (Value)BooleanValue$.MODULE$.apply(cookie.isHttpOnly(), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
        }
        if (cookie.isHttpOnly()) {
            cookieObjectSeq = (Seq)cookieObjectSeq.$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply("secure"), (Value)BooleanValue$.MODULE$.apply(!cookie.isHttpOnly(), BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3())), Seq$.MODULE$.canBuildFrom());
        }
        cookiesSeq$1.elem = (Seq)((Seq)cookiesSeq$1.elem).$colon$plus((Object)new KeyValuePair((Value)KeyValue$.MODULE$.apply(cookie.getName()), (Value)ObjectValue$.MODULE$.apply(cookieObjectSeq, (LocationCapable)UnknownLocationCapable$.MODULE$)), Seq$.MODULE$.canBuildFrom());
    }

    private static final Value liftedTree1$1(EvaluationContext implicitCtx$1, KeyValuePair compress$1) {
        Value value;
        try {
            value = BooleanType$.MODULE$.coerce(compress$1._2(), implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception("request.allowCompression must be a Boolean", e);
        }
        return value;
    }

    private static final Value liftedTree2$1(EvaluationContext implicitCtx$1, Option maybeRequestHeaders$1) {
        Value value;
        try {
            value = ObjectType$.MODULE$.coerce(((KeyValuePair)maybeRequestHeaders$1.get())._2(), implicitCtx$1).materialize(implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception("request.headers must be an Object", e);
        }
        return value;
    }

    public static final /* synthetic */ void $anonfun$fun$8(EvaluationContext implicitCtx$1, scala.collection.mutable.Map requestHeaders$1, String keyString$1, KeyValuePair value) {
        HttpString httpString;
        String string;
        try {
            string = (String)StringType$.MODULE$.coerce(value._2(), implicitCtx$1).evaluate(implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid header value `", "`. It must be a String"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyString$1})), e);
        }
        String headerValue = string;
        try {
            httpString = HttpString.tryFromString((String)keyString$1);
        }
        catch (Throwable e) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid header name: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyString$1})), e);
        }
        HttpString headerName = httpString;
        Seq newValue = (Seq)((SeqLike)requestHeaders$1.getOrElse((Object)headerName.toString(), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).$colon$plus((Object)headerValue, Seq$.MODULE$.canBuildFrom());
        requestHeaders$1.update((Object)headerName.toString(), (Object)newValue);
    }

    public static final /* synthetic */ void $anonfun$fun$7(EvaluationContext implicitCtx$1, scala.collection.mutable.Map requestHeaders$1, Value maybeRequestHeadersObject$1, KeyValuePair kvpv) {
        block0: {
            QualifiedName key = (QualifiedName)kvpv._1().evaluate(implicitCtx$1);
            String keyString = key.name();
            Option values = ((ObjectSeq)maybeRequestHeadersObject$1.evaluate(implicitCtx$1)).allKeyValuesOf(kvpv._1(), implicitCtx$1);
            if (!values.isDefined()) break block0;
            ((ObjectSeq)values.get()).toSeq(implicitCtx$1).foreach((Function1 & Serializable & scala.Serializable)value -> {
                HttpRequestFunction$.$anonfun$fun$8(implicitCtx$1, requestHeaders$1, keyString, value);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static final Value liftedTree3$1(EvaluationContext implicitCtx$1, Option maybeRequestCookies$1) {
        Value value;
        try {
            value = ObjectType$.MODULE$.coerce(((KeyValuePair)maybeRequestCookies$1.get())._2(), implicitCtx$1).materialize(implicitCtx$1);
        }
        catch (Throwable e) {
            throw new Exception("request.cookies must be an Object", e);
        }
        return value;
    }

    public static final /* synthetic */ void $anonfun$fun$11(EvaluationContext implicitCtx$1, scala.collection.mutable.Map requestHeaders$1, String keyString$2, KeyValuePair value) {
        String headerValue = (String)StringType$.MODULE$.coerce(value._2(), implicitCtx$1).evaluate(implicitCtx$1);
        String cookie = keyString$2 + "=" + headerValue;
        Seq newValue = (Seq)((SeqLike)requestHeaders$1.getOrElse((Object)HttpHeader$.MODULE$.COOKIE_HEADER(), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).$colon$plus((Object)cookie, Seq$.MODULE$.canBuildFrom());
        requestHeaders$1.update((Object)HttpHeader$.MODULE$.COOKIE_HEADER(), (Object)newValue);
    }

    private HttpRequestFunction$() {
        MODULE$ = this;
    }
}

