package org.mule.weave.v2.module.commons.java.writer

import scala.collection.mutable
import scala.collection.mutable.ArrayBuffer

//This class is used to build the ClassTree from the class schema. Example: [] as Any {class: "java.util.Optional<Array<String>>"}
class ClassSchemaNode(val className: String) {

  val children: ArrayBuffer[ClassSchemaNode] = mutable.ArrayBuffer[ClassSchemaNode]()

  def addChild(cl: ClassSchemaNode): ArrayBuffer[ClassSchemaNode] = children.+=(cl)

  def firstChild: Option[ClassSchemaNode] = if (hasChild) Some(children.head) else None

  def hasChild: Boolean = children.nonEmpty
}
