package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.OptionalLong

class OptionalLongDataConverter extends DataConverter[OptionalLong] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[OptionalLong] = {
    //Makes sure that we are wrapping a java value
    if (source == null) {
      Some(OptionalLong.empty())
    } else {
      val converter = new LongDataConverter()
      converter
        .convert(source, schema)
        .map((intValue) => OptionalLong.of(intValue))
    }
  }
}
