package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.core.io.LazySeekableStream
import org.mule.weave.v2.core.io.SeekableStream
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.BinaryValue
import org.mule.weave.v2.model.values.Value

import java.io.File
import java.io.InputStream
import java.nio.ByteBuffer

class JavaBinaryValue(content: (EvaluationContext) => SeekableStream, val locationString: () => String, val _underlying: Any) extends JavaValue[SeekableStream] with BinaryValue {

  var value: SeekableStream = _

  override def evaluate(implicit ctx: EvaluationContext): SeekableStream = {
    if (value == null) {
      value = content(ctx)
    }
    value
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = _underlying
}

class JavaInputStreamBinaryValue(val locationString: () => String, val _underlying: InputStream) extends JavaValue[SeekableStream] with BinaryValue {

  var value: SeekableStream = _

  override def evaluate(implicit ctx: EvaluationContext): SeekableStream = {
    if (value == null) {
      value = new LazySeekableStream(() => SeekableStream(_underlying))
    }
    value
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = _underlying
}

object JavaBinaryValue {
  def apply(byte: Array[Byte], loc: () => String): JavaBinaryValue = {
    new JavaBinaryValue((ctx) => SeekableStream(byte), loc, byte)
  }

  def apply(bigByte: Array[java.lang.Byte], loc: () => String): JavaBinaryValue = {
    new JavaBinaryValue(
      (ctx) => {
        val bytes: Array[Byte] = ctx.serviceManager.memoryService.newByteArray("JavaBinaryValue", bigByte.length)
        var i: Int = 0
        bigByte.foreach((b: java.lang.Byte) => {
          bytes(i) = b.byteValue()
          i += 1
        })
        SeekableStream(bytes)
      },
      loc,
      bigByte)
  }

  def apply(byte: InputStream, loc: () => String): JavaInputStreamBinaryValue = {
    new JavaInputStreamBinaryValue(loc, byte)
  }

  def apply(byte: ByteBuffer, loc: () => String): JavaBinaryValue = {
    new JavaBinaryValue((ctx) => SeekableStream(byte)(ctx), loc, byte)
  }

  def apply(file: File, loc: () => String): JavaBinaryValue = {
    new JavaBinaryValue((ctx) => SeekableStream(file)(ctx), loc, file)
  }
}
