package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.sql.Blob
import javax.sql.rowset.serial.SerialBlob

class BlobDataConverter extends DataConverter[Blob] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Blob] = {
    val byteArrayConverter = new ByteArrayDataConverter
    byteArrayConverter.convert(source, schema).map(new SerialBlob(_))
  }
}
