package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

import java.math.BigInteger

class BigIntegerDataConverter extends DataConverter[BigInteger] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[BigInteger] = {
    source match {
      case bigInteger: BigInteger => Some(bigInteger)
      case _ => {
        val d: BigInteger = source match {
          case l: Long                  => BigInteger.valueOf(l)
          case i: Int                   => BigInteger.valueOf(i.toLong)
          case d: Double                => BigInteger.valueOf(d.toLong)
          case d: Float                 => BigInteger.valueOf(d.toLong)
          case s: Short                 => BigInteger.valueOf(s.toLong)
          case n: Number                => n.toBigInt.bigInteger
          case bd: java.math.BigDecimal => bd.toBigInteger
          case bi: java.math.BigInteger => bi
          case str: String              => new BigInteger(str)
          case _                        => null
        }
        Option(d)
      }
    }

  }
}
