package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter.DateDataConverter$

import java.time.Instant
import java.util

class InstantDataConverter extends DataConverter[Instant] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Instant] = {
    source match {
      case instant: Instant => Some(instant)
      case _ => {
        val maybeDate: Option[util.Date] = DateDataConverter$.convert(source, schema)
        if (maybeDate.isDefined) {
          Option(maybeDate.get.toInstant)
        } else {
          None
        }
      }
    }

  }
}
