package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.util.UUID

class UUIDDataConverter extends DataConverter[UUID] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[UUID] = {
    source match {

      case str: String => Some(UUID.fromString(str))
      case _           => None
    }
  }
}