package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.NullValue
import org.mule.weave.v2.model.values.NumberValue

class JavaNaNValue(nanNumber: Number, val locationString: () => String) extends NullValue with JavaValue[Null] {

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    Some(JavaSchema(underlying().getClass, NumberValue.NaN_PropertySeq))
  }

  override def underlying()(implicit ctx: EvaluationContext): Any = nanNumber
}
