package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.math.Number

class IntDataConverter extends DataConverter[Int] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[Int] = {
    source match {
      case l: Long                  => Option(l.toInt)
      case i: Int                   => Option(i)
      case d: Double                => Option(d.toInt)
      case d: Float                 => Option(d.toInt)
      case s: Short                 => Option(s.toInt)
      case n: Number                => Option(n.toInt)
      case bd: java.math.BigDecimal => Option(bd.intValue())
      case bi: java.math.BigInteger => Option(bi.intValue())
      case str: String              => Option(str.toInt)
      case _                        => None
    }

  }
}
