package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext

/**
  * Mark a value as expensive so that it should be cached when possible
  */
trait JavaHeavyValueCapable {
  /**
    * Check if the given value should consider as heavy value.
    *
    * @param ctx The evaluation context.
    * @return true when it should consider as heavy value
    */
  def isHeavyValue(implicit ctx: EvaluationContext): Boolean
}
