/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.commons.java.writer.converter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.module.commons.java.writer.converter.DataConverter;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00154AAB\u0004\u00015!)A\u0006\u0001C\u0001[!)q\u0006\u0001C!a!)A\n\u0001C\u0001\u001b\")Q\u000b\u0001C\u0001-\")1\f\u0001C\u00019\n)2)\u00197f]\u0012\f'\u000fR1uC\u000e{gN^3si\u0016\u0014(B\u0001\u0005\n\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u000b\u0017\u00051qO]5uKJT!\u0001D\u0007\u0002\t)\fg/\u0019\u0006\u0003\u001d=\tqaY8n[>t7O\u0003\u0002\u0011#\u00051Qn\u001c3vY\u0016T!AE\n\u0002\u0005Y\u0014$B\u0001\u000b\u0016\u0003\u00159X-\u0019<f\u0015\t1r#\u0001\u0003nk2,'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0004E\r*S\"A\u0004\n\u0005\u0011:!!\u0004#bi\u0006\u001cuN\u001c<feR,'\u000f\u0005\u0002'U5\tqE\u0003\u0002)S\u0005!Q\u000f^5m\u0015\u0005a\u0011BA\u0016(\u0005!\u0019\u0015\r\\3oI\u0006\u0014\u0018A\u0002\u001fj]&$h\bF\u0001/!\t\u0011\u0003!A\u0004d_:4XM\u001d;\u0015\u0007Ej$\t\u0006\u00023kA\u0019AdM\u0013\n\u0005Qj\"AB(qi&|g\u000eC\u00037\u0005\u0001\u000fq'A\u0002dib\u0004\"\u0001O\u001e\u000e\u0003eR!AO\t\u0002\u000b5|G-\u001a7\n\u0005qJ$!E#wC2,\u0018\r^5p]\u000e{g\u000e^3yi\")aH\u0001a\u0001\u007f\u000511o\\;sG\u0016\u0004\"\u0001\b!\n\u0005\u0005k\"aA!os\")1I\u0001a\u0001\t\u000611o\u00195f[\u0006\u00042\u0001H\u001aF!\t1%*D\u0001H\u0015\t\u0019\u0005J\u0003\u0002Js\u0005I1\u000f\u001e:vGR,(/Z\u0005\u0003\u0017\u001e\u0013aaU2iK6\f\u0017AC1t\u0007\u0006dWM\u001c3beR\u0011QE\u0014\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\u0005i&lW\r\u0005\u0002R'6\t!K\u0003\u0002PS%\u0011AK\u0015\u0002\u000e5>tW\r\u001a#bi\u0016$\u0016.\\3\u0002\u0017\u001d,G\u000fV5nKj{g.\u001a\u000b\u0003/j\u0003\"A\n-\n\u0005e;#\u0001\u0003+j[\u0016TvN\\3\t\u000b=#\u0001\u0019\u0001)\u0002-\u0019\fG\u000e\u001c2bG.\u001cFO]5oO\u000e{WM]2j_:$\"\u0001U/\t\u000by+\u0001\u0019A0\u0002\u0007M$(\u000f\u0005\u0002aG6\t\u0011M\u0003\u0002cS\u0005!A.\u00198h\u0013\t!\u0017M\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\r")
public class CalendarDataConverter
implements DataConverter<Calendar> {
    @Override
    public Option<String> format(Map<String, Object> arguments) {
        return DataConverter.format$(this, arguments);
    }

    @Override
    public Option<String> separator(Map<String, Object> arguments) {
        return DataConverter.separator$(this, arguments);
    }

    @Override
    public Option<String> encoding(Map<String, Object> arguments) {
        return DataConverter.encoding$(this, arguments);
    }

    @Override
    public Option<Calendar> convert(Object source, Option<Schema> schema, EvaluationContext ctx) {
        Calendar calendar;
        Object object = source;
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(localDateTime.getYear(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
            instance.set(14, localDateTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            calendar = this.asCalendar(zonedDateTime);
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(11, localTime.getHour());
            instance.set(12, localTime.getMinute());
            instance.set(13, localTime.getSecond());
            instance.set(14, localTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            Calendar instance = Calendar.getInstance(TimeZone.getTimeZone(offsetTime.getOffset().getId()));
            instance.set(11, offsetTime.getHour());
            instance.set(12, offsetTime.getMinute());
            instance.set(13, offsetTime.getSecond());
            instance.set(14, offsetTime.get(ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            Calendar instance = Calendar.getInstance();
            instance.set(2, localDate.getMonthValue() - 1);
            instance.set(5, localDate.getDayOfMonth());
            instance.set(1, localDate.getYear());
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            calendar = instance;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            Calendar instance = Calendar.getInstance();
            instance.setTime(new Date(l));
            calendar = instance;
        } else if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            ZonedDateTime zonedDateTime = this.fallbackStringCoercion(charSequence);
            calendar = this.asCalendar(zonedDateTime);
        } else {
            Calendar calendar2;
            calendar = object instanceof Calendar ? (calendar2 = (Calendar)object) : null;
        }
        Calendar calendar3 = calendar;
        return Option$.MODULE$.apply((Object)calendar3);
    }

    /*
     * WARNING - void declaration
     */
    public Calendar asCalendar(ZonedDateTime time) {
        void var2_2;
        Calendar instance = Calendar.getInstance(this.getTimeZone(time));
        instance.set(time.getYear(), time.getMonthValue() - 1, time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
        instance.set(14, time.get(ChronoField.MILLI_OF_SECOND));
        return var2_2;
    }

    public TimeZone getTimeZone(ZonedDateTime time) {
        String string;
        String string2 = time.getZone().getId();
        TimeZone timeZone = string2 != null && (string = string2).matches("[+-][0-9]{2}:[0-9]{2}") ? TimeZone.getTimeZone(new StringBuilder(3).append("GMT").append(time.getZone().getId()).toString()) : TimeZone.getTimeZone(time.getZone().getId());
        return timeZone;
    }

    public ZonedDateTime fallbackStringCoercion(CharSequence str) {
        return (ZonedDateTime)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ZonedDateTime.parse(str)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDateTime.parse(str).atZone(ZoneOffset.UTC))).get();
    }

    public CalendarDataConverter() {
        DataConverter.$init$(this);
    }
}

