package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.io.ByteArrayInputStream
import java.io.InputStream

class InputStreamDataConverter extends DataConverter[InputStream] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[InputStream] = {
    source match {
      case is: InputStream => Some(is)
      case ch: Array[Byte] => Some(new ByteArrayInputStream(ch))
      case str: String     => Some(new ByteArrayInputStream(str.getBytes))
      case _               => None
    }
  }
}
