package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.parser.location.Location

trait JavaValue[T] extends Value[T] {
  def location(): Location = new JavaLocation(locationString())

  val locationString: () => String

  def underlying()(implicit ctx: EvaluationContext): Any

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    Some(JavaSchema(underlying().getClass))
  }

  override def materialize(implicit ctx: EvaluationContext): Value[T] = this
}