package org.mule.weave.v2.module.commons.java.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema

import java.time.ZoneOffset
import java.util.TimeZone

class TimeZoneDataConverter extends DataConverter[TimeZone] {
  override def convert(source: Any, schema: Option[Schema])(implicit ctx: EvaluationContext): Option[TimeZone] = {
    source match {
      case timeZone: TimeZone => Option(timeZone)
      case zone: ZoneOffset   => Option(TimeZone.getTimeZone(zone))
      case _                  => None
    }
  }
}
