package org.mule.weave.v2.module.commons.java.value

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.LocalTimeValue

import java.time.LocalTime

trait JavaLocalTimeValue extends LocalTimeValue with JavaValue[LocalTime] {
}

object JavaLocalTimeValue {
  def apply(value: LocalTime, locationString: () => String): JavaLocalTimeValue = new JavaTimeLocalTimeValue(value, locationString)
}

class JavaTimeLocalTimeValue(value: LocalTime, val locationString: () => String) extends JavaLocalTimeValue {
  override def underlying()(implicit ctx: EvaluationContext): Any = value

  override def evaluate(implicit ctx: EvaluationContext): T = value
}

