package org.mule.weave.v2.module.pojo.exception

import java.io.PrintWriter
import java.io.StringWriter
import org.mule.weave.v2.core.exception.ReaderException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.LocationCapable

class JavaFunctionCallException(methodName: String, className: String, argTypes: Seq[String], locationCapable: LocationCapable, cause: Throwable)(implicit ctx: EvaluationContext) extends ReaderException {
  override def location: Location = locationCapable.location()

  override def message: String = {
    val writer = new StringWriter()
    val stackTracePrinter = new PrintWriter(writer)
    val stacktraceLength = ctx.serviceManager.settingsService.java().stackTrace
    if (stacktraceLength < 0) {
      cause.printStackTrace(stackTracePrinter)
    } else {
      val stack = cause.getStackTrace()
      var i = 0
      while (stack.length > i && i < stacktraceLength) {
        val element: StackTraceElement = stack.apply(i)
        val stackString: String = "\t" + element.getClassName + "." + element.getMethodName + "(" + element.getFileName + ":" + element.getLineNumber + ")"
        stackTracePrinter.println(stackString)
        i = i + 1
      }
    }
    s"An exception occurred while trying to execute function  `${className}.${methodName}(${argTypes.mkString(", ")})`.\nCaused by: ${cause.getClass.getName + ": " + cause.getMessage}" + "\n" + writer.toString
  }
}
