package org.mule.weave.v2.module.pojo

import java.util.logging.Logger
import scala.util.Failure
import scala.util.Success
import scala.util.Try

/**
  * Service that loads class
  */
trait ClassLoaderService {
  def loadClass(className: String): Option[Class[_]]
}

object DefaultClassLoaderService extends ClassLoaderService {
  private val logger: Logger = Logger.getLogger(DefaultClassLoaderService.getClass.getName)

  override def loadClass(className: String): Option[Class[_]] = {
    val maybe = Try(Thread.currentThread().getContextClassLoader.loadClass(className)).orElse(Try(getClass.getClassLoader.loadClass(className)))
    maybe match {
      case Success(value) =>
        Some(value)
      case Failure(_) =>
        None
    }
  }
}
