package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.model.values.wrappers.WrapperValue
import org.mule.weave.v2.module.commons.java.value.JavaLocation
import org.mule.weave.v2.module.commons.java.value.JavaValue
import org.mule.weave.v2.parser.location.Location

class JavaBeanPropertyValue(property: PropertyDefinition, bean: Any, val locationString: () => String) extends WrapperValue with JavaValue[Any] {

  @volatile
  private var javaValue: Value[_] = _

  def value(implicit ctx: EvaluationContext): Value[_] = {
    if (javaValue == null) {
      synchronized {
        if (javaValue == null) {
          javaValue = ReflectionJavaValueConverter.convert(property.read(bean, this), locationString)
        }
      }
    }
    javaValue
  }

  override def location(): Location = new JavaLocation(locationString())

  override def underlying()(implicit ctx: EvaluationContext): Any = property.read(bean, this)

  override def schema(implicit ctx: EvaluationContext): Option[Schema] = {
    value.schema
  }
}
