package org.mule.weave.v2.module.pojo.exception

import java.io.PrintWriter
import java.io.StringWriter

import org.mule.weave.v2.core.exception.ReaderException
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.LocationCapable

class IllegalReadPropertyAccessException(field: String, className: String, locationCapable: LocationCapable, cause: Throwable)(implicit ctx: EvaluationContext)
    extends ReaderException {

  override def location: Location = locationCapable.location()

  override def message: String = {
    s"Illegal access while trying to access field `$field` at class `$className`. Please verify that the correct getter method is being defined.\nCaused by: ${cause.getClass.getName}: ${cause.getMessage}\n$getCauseStackTrace"
  }

  private def getCauseStackTrace: String = {
    val writer = new StringWriter()
    val stackTracePrinter = new PrintWriter(writer)
    val stacktraceLength = ctx.serviceManager.settingsService.java().stackTrace
    if (stacktraceLength < 0) {
      cause.printStackTrace(stackTracePrinter)
    } else {
      val stack = cause.getStackTrace
      var i = 0
      while (stack.length > i && i < stacktraceLength) {
        val element: StackTraceElement = stack.apply(i)
        val stackString: String = "\t" + element.getClassName + "." + element.getMethodName + "(" + element.getFileName + ":" + element.getLineNumber + ")"
        stackTracePrinter.println(stackString)
        i = i + 1
      }
    }
    writer.toString
  }
}
