package org.mule.weave.v2.module.java

import org.mule.weave.v2.model.values.FunctionValue
import org.mule.weave.v2.model.values.NativeValueProvider

class JavaSystemNativeValueProvider extends NativeValueProvider {

  val methods: Map[String, FunctionValue] = toMap(Seq(new JavaInvokeFunction(), new JavaFieldRefFunction()))

  override def name(): String = "java"

  override def getNativeFunction(name: String): Option[FunctionValue] = {
    methods.get(name)
  }
}
