package org.mule.weave.v2.module.java.reflection

import java.lang.reflect.AccessibleObject

trait AccessibilityObjectValidator {
  def canAccess(accessibleObject: AccessibleObject, instance: Any): Boolean
}

object AlwaysCanAccessValidator extends AccessibilityObjectValidator {

  override def canAccess(accessibleObject: AccessibleObject, instance: Any): Boolean = {
    true
  }
}

object ValidateAccessibilityObjectValidator extends AccessibilityObjectValidator {

  override def canAccess(accessibleObject: AccessibleObject, instance: Any): Boolean = {
    var access = false
    try {
      access = accessibleObject.canAccess(instance)
    } catch {
      case _: Exception =>
      // Nothing to do
    }
    access
  }
}