package org.mule.weave.v2.module.pojo.writer.entry

import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.entry.WriterEntry
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

class ArrayEntry(override val location: LocationCapable, clazz: Class[_], override val schemaOption: Option[Schema]) extends WriterEntry {

  override implicit val converter: BaseJavaDataConverter = JavaDataConverter

  var array: Any = java.lang.reflect.Array.newInstance(clazz, 0)

  def write(value: Any) {
    val currentLength: Int = java.lang.reflect.Array.getLength(array)
    val newArray = java.lang.reflect.Array.newInstance(clazz, currentLength + 1)
    System.arraycopy(array, 0, newArray, 0, currentLength)
    java.lang.reflect.Array.set(newArray, currentLength, value)
    array = newArray
  }

  override def entryType(): Class[_] = clazz

  override def resolveEntryValue(): Any = {
    array
  }

}
