package org.mule.weave.v2.module.pojo.writer.converter

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.JavaTypesHelper._
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.converter.BlobDataConverter
import org.mule.weave.v2.module.commons.java.writer.converter.ClobDataConverter
import org.mule.weave.v2.module.commons.java.writer.converter.DataConverter

import java.sql.Blob
import java.sql.Clob
import scala.util.Try

object JavaDataConverter extends BaseJavaDataConverter {
  implicit object BlobDataConverter$ extends BlobDataConverter

  implicit object ClobDataConverter$ extends ClobDataConverter

  implicit object ClassDataConverter$ extends ClassDataConverter

  override def to[_](value: Any, schema: Option[Schema], clazz: Class[_])(implicit ctx: EvaluationContext): Option[_] = {
    val baseTo = super.to(value, schema, clazz)

    if (baseTo.isDefined) {
      baseTo
    } else if (isBlob(clazz)) {
      DataConverter.to[Blob](value, schema)
    } else if (isClob(clazz)) {
      DataConverter.to[Clob](value, schema)
    } else if (clazz.isAssignableFrom(value.getClass)) {
      Some(value)
    } else if (isClass(clazz)) {
      DataConverter.to[java.lang.Class[_]](value, schema)
    } else if (clazz.isArray && value.getClass.isArray) {
      Try({
        val length: Int = java.lang.reflect.Array.getLength(value)
        val array = java.lang.reflect.Array.newInstance(clazz.getComponentType, length)
        var i: Int = 0
        while (i < length) {
          val arrayValue: AnyRef = java.lang.reflect.Array.get(value, i)
          val arrayValueAdapted: Option[_] = to(arrayValue, schema, clazz.getComponentType)
          if (arrayValueAdapted.isDefined) {
            java.lang.reflect.Array.set(array, i, arrayValueAdapted.get)
            i += 1
          } else {
            return None
          }
        }
        array
      }).toOption
    } else {
      JavaCustomConverter.convert(value, schema, clazz)
    }
  }
}
