package org.mule.weave.v2.module.pojo.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location

class InvalidBuilderReturnTypeException(val location: Location, val builderClass: Class[_], val expectedClass: Class[_], val actualClass: Class[_]) extends ExecutionException {
  override def message: String = s"Builder build method from '${builderClass}' should generate '" + expectedClass + "' but was '" + actualClass + "'"

}
