package org.mule.weave.v2.module.pojo.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location

class CannotInstantiateException(val location: Location, val sourceClass: String, val reason: String = "") extends ExecutionException {
  override def message: String = "Cannot instantiate class '" + sourceClass + "'" + (if (reason.isEmpty) "" else " Caused by: " + reason)
}
