package org.mule.weave.v2.module.pojo.writer.entry

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.QualifiedName
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.entry.PropertyAwareEntry
import org.mule.weave.v2.module.commons.java.writer.entry.WriterEntry
import org.mule.weave.v2.module.pojo.reader.BeanDefinition
import org.mule.weave.v2.module.pojo.reader.JavaBeanHelper
import org.mule.weave.v2.module.pojo.reader.PropertyDefinition
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

class BeanContainerEntry(override val location: LocationCapable, element: Any, override val schemaOption: Option[Schema])(implicit ctx: EvaluationContext) extends WriterEntry with PropertyAwareEntry {

  override implicit val converter: BaseJavaDataConverter = JavaDataConverter

  override def write(value: Any): Unit = {}

  override def entryType(): Class[_] = element.getClass

  override def resolveEntryValue(): Any = element

  override def createPropertyEntry(location: LocationCapable, qname: QualifiedName, schema: Option[Schema]): WriterEntry = {
    val propertyDescriptor: PropertyDefinition = getPropertyDescriptor(qname)
    new BeanPropertyEntry(location, propertyDescriptor, element, schema)
  }

  def getPropertyDescriptor(qname: QualifiedName): PropertyDefinition = {
    val definition: BeanDefinition = JavaBeanHelper.getBeanDefinition(element)
    definition.getProperty(qname.name)
  }
}
