package org.mule.weave.v2.module.java.reflection

import scala.collection.mutable

class ClassHierarchyIterator(baseClass: Class[_]) extends Iterator[Class[_]] {
  private val remaining = mutable.Queue[Class[_]]()
  private val visited = mutable.Set[Class[_]]()

  load(baseClass)

  private def load(clazz: Class[_]): Unit = {
    if (clazz != null && !visited.contains(clazz)) {
      visited += clazz
      remaining.enqueue(clazz)
    }
  }

  override def hasNext: Boolean = {
    remaining.nonEmpty
  }

  override def next(): Class[_] = {
    if (hasNext) {
      val current = remaining.dequeue()
      load(current.getSuperclass)
      val it = current.getInterfaces.iterator
      while (it.hasNext) {
        load(it.next())
      }
      current
    } else {
      Iterator.empty.next()
    }
  }
}
