package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.commons.java.value.JavaMapObjectValue
import org.mule.weave.v2.module.commons.java.value.JavaValueConverter

import java.util
import java.util.function.{ Function => JFunction }

object ReflectionJavaValueConverter extends JavaValueConverter {
  override def doConvertValue(value: Any, loc: () => String)(implicit ctx: EvaluationContext): Value[_] = {
    value match {
      //Before collections as SQLException is an Iterator :(
      case ex: java.sql.SQLException => JavaBeanObjectValue(ex, loc)
      //Collection
      case it: java.util.Iterator[_] => new JavaIteratorArrayValue(it, loc)
      case it: java.lang.Iterable[_] => new JavaIteratorArrayValue(it.iterator(), loc)
      //Function
      case fn: JFunction[Any, Any]   => new JavaFunctionValue(fn, loc)
      case _ => {
        //For performance reasons we only allow to override with java value mapper Beans and Maps that are not HashMap or LinkedHashMap
        val mappedValue: Option[Value[_]] = JavaValueMapper.map(value, loc)
        if (mappedValue.isDefined) {
          mappedValue.get
        } else {
          value match {
            case array: Array[_]         => new JavaArrayJavaValue(array, loc)
            case map: util.Map[Any, Any] => new JavaMapObjectValue(map, loc, this)
            case enum if isEnum(value)   => JavaEnumValue(enum.asInstanceOf[Enum[_]], loc)
            case bean                    => JavaBeanObjectValue(bean, loc)
          }
        }
      }
    }
  }
  private def isEnum(value: Any) = {
    val clazz = value.getClass
    //For enums with implementation the class is not an enum but its parent is
    clazz.isEnum || (clazz.getSuperclass != null && clazz.getSuperclass.isEnum)
  }
}
