package org.mule.weave.v2.module.pojo.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location

class ClassNotFoundException(val location: Location, val sourceClass: String, classLoaderNames: Seq[ClassLoaderName]) extends ExecutionException {

  def this(location: Location, sourceClass: String, currentClassLoader: ClassLoader) = {
    this(location, sourceClass, Seq(ClassLoaderName("CurrentClassLoader", currentClassLoader.getClass.getName)))
  }

  override def message: String = {
    val separator = System.lineSeparator()
    val usedClassLoadersMsg = classLoaderNames.mkString(separator, separator, separator)
    "Unable to find class '" + sourceClass + "'" + usedClassLoadersMsg
  }
}

case class ClassLoaderName(classLoaderType: String, name: String) {
  override def toString: String = s"$classLoaderType: $name"
}