package org.mule.weave.v2.module.pojo.writer.interceptor

import org.mule.weave.v2.core.env.WeaveRuntime
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.values.Value

/**
  * Used to intercept the creation of an entire Data Structure.
  */
trait JavaWriterInterceptor {

  def handles(entryType: Class[_]): Boolean

  def write(value: Value[_], genericProvider: Option[(Int) => Option[Class[_]]])(implicit ctx: EvaluationContext): Any

}

object JavaWriterInterceptor {
  lazy val interceptor: Seq[JavaWriterInterceptor] = {
    WeaveRuntime.getServiceProvider().serviceImplementations(classOf[JavaWriterInterceptor])
  }

  def interceptorFor(clazz: Class[_]): Option[JavaWriterInterceptor] = {
    interceptor.find(_.handles(clazz))
  }
}
