package org.mule.weave.v2.module.pojo.function

import org.mule.weave.v2.core.exception.InvalidMimeTypeException
import org.mule.weave.v2.model.DefaultEvaluationContext
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.ServiceManager
import org.mule.weave.v2.model.capabilities.EmptyLocationCapable
import org.mule.weave.v2.model.values.BaseFunctionValue
import org.mule.weave.v2.model.values.FunctionParameter
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.DataFormatManager
import org.mule.weave.v2.module.pojo.writer.JavaWriter
import org.mule.weave.v2.module.reader.Reader
import org.mule.weave.v2.module.reader.SourceProvider
import org.mule.weave.v2.module.writer.Writer
import org.mule.weave.v2.parser.location.LocationCapable

import scala.collection.mutable

class JavaFunctionValue(method: JavaFunction) extends BaseFunctionValue with EmptyLocationCapable {

  val memo: mutable.Map[Seq[AnyRef], Value[_]] = collection.mutable.Map[Seq[AnyRef], Value[_]]()

  override def doCall(args: Array[Value[_]])(implicit ctx: EvaluationContext): Value[_] = {

    val classLoader: ClassLoader = getClass.getClassLoader
    val arguments: Seq[AnyRef] = args.map((v: Value[_]) => {
      toJava(classLoader, this, ctx, v).asInstanceOf[AnyRef]
    })
    if (memo.contains(arguments) && method.idempotent()) {
      memo(arguments)
    } else {
      val methodInvocationResult: AnyRef = method.invoke(arguments.toArray)
      val reader: Reader = DataFormatManager.byContentType(method.returnMediaType()) match {
        case Some(module) => module.reader(SourceProvider(methodInvocationResult))
        case None         => throw new InvalidMimeTypeException(method.returnMediaType(), location())
      }
      val result: Value[_] = reader.read(method.name())
      if (method.idempotent()) {
        memo.put(arguments, result)
      }
      result
    }

  }

  def toJava(classLoader: ClassLoader, location: LocationCapable, ctx: EvaluationContext, args: Value[_]): Any = {
    val javaWriter: Writer = JavaWriter(classLoader)
    val serviceManager = ctx.serviceManager
    val childExecutionContext = DefaultEvaluationContext(initialNestedExecutionCount = ctx.asyncExecutionCount(), serviceManager = new ServiceManager(logger = serviceManager.loggingService, serviceProvider = serviceManager.serviceProvider))
    javaWriter.startDocument(location)
    javaWriter.writeValue(args)(childExecutionContext)
    javaWriter.endDocument(location)
    val result: Any = javaWriter.result
    result
  }

  override lazy val parameters: Array[FunctionParameter] = {
    method.params().map((param) => FunctionParameter(param))
  }

  override def minParams: Int = method.params().length
}
