package org.mule.weave.v2.module.pojo.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location

class JavaPropertySetException(val location: Location, val value: String, val valueClass: String, val propertyName: String, val propertyType: String) extends ExecutionException {
  override def message: String = {
    "Unable to write '" + value + "' with class '" + valueClass + "' to property '" + propertyName + "' with class '" + propertyType + "'. Please verify that the correct setter method is being defined."
  }
}

