package org.mule.weave.v2.module.pojo.exception

import org.mule.weave.v2.core.exception.ReaderException
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.LocationCapable

class JavaPropertyAccessException(field: String, className: String, locationCapable: LocationCapable, cause: Throwable) extends ReaderException {
  override def location: Location = locationCapable.location()

  override def message: String = {
    s"An exception occurred while trying to access property `$field` at class `$className`.\nCaused by: ${cause.getClass.getName}: ${cause.getMessage}"
  }
}
