package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.pojo.exception.InvalidPropertyNameException
import org.mule.weave.v2.parser.location.LocationCapable

class DefaultPropertyDefinition(val name: String, val clazz: Class[_]) extends PropertyDefinition {

  override protected def doRead(instance: Any, locationCapable: LocationCapable)(implicit ctx: EvaluationContext): Any = {
    readMethod match {
      case Some(method) =>
        method.invoke(instance)
      case _ =>
        throw new InvalidPropertyNameException(locationCapable.location(), name, clazz)
    }
  }

  override protected def doWrite(instance: Any, value: AnyRef, location: LocationCapable)(implicit ctx: EvaluationContext): Boolean = {
    writeMethod match {
      case Some(method) =>
        method.invoke(instance, value)
        true
      case _ =>
        false
    }
  }

  override protected def doResolveClassType(implicit ctx: EvaluationContext): Class[_] = {
    writeMethod match {
      case Some(m) => m.getParameterTypes.apply(0)
      case _ =>
        readMethod match {
          case Some(m) =>
            m.getReturnType
          case None =>
            throw new IllegalStateException("No read or write handler for " + name)
        }
    }
  }
}
