package org.mule.weave.v2.module.pojo.writer

import org.mule.weave.v2.model.DefaultEvaluationContext
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.ServiceManager
import org.mule.weave.v2.model.capabilities.UnknownLocationCapable
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.writer.Writer
import org.mule.weave.v2.module.writer.WriterHelper

import java.io.Closeable
import java.io.IOException

class JavaWriterIterator(classLoader: ClassLoader, ctx: EvaluationContext, seq: Iterator[Value[_]]) extends java.util.Iterator[Any] with Closeable {
  //Mark new async execution
  ctx.newAsyncExecution()
  var closed: Boolean = false

  override def hasNext: Boolean = {
    if (closed) {
      false
    } else {
      closeOnException {
        val nextIsPresent = seq.hasNext
        if (!nextIsPresent) {
          close()
        }
        nextIsPresent
      }
    }
  }

  override def next(): Any = closeOnException {
    val writer: Writer = JavaWriter(classLoader)
    val serviceManager = ctx.serviceManager
    val childExecutionContext: DefaultEvaluationContext = DefaultEvaluationContext(
      initialNestedExecutionCount = ctx.asyncExecutionCount(),
      serviceManager = new ServiceManager(logger = serviceManager.loggingService, serviceProvider = serviceManager.serviceProvider))
    WriterHelper.writeAndGetResult(writer, seq.next(), UnknownLocationCapable)(childExecutionContext)._1
  }

  override def remove(): Unit = {
    close()
    throw new UnsupportedOperationException("Remove operation is not supported.")
  }

  def closeOnException[X](f: => X): X = {
    try {
      f
    } catch {
      case e: Exception => {
        try {
          close()
        } catch {
          case _: Exception =>
        }
        throw e
      }
    }
  }

  @throws(classOf[IOException])
  override def close(): Unit = {
    closed = true
    ctx.close()
  }

}
