package org.mule.weave.v2.module.pojo.reader

import org.mule.weave.v2.cache.service.Cache
import org.mule.weave.v2.core.RuntimeConfigProperties
import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.pojo.ClassBeanDefinitionLookup

import java.util.Locale._

object JavaBeanHelper {
  //Make it lazy so that if getBeanDefinition is not
  private lazy val cache = Cache.builder()
    .maximumSize(RuntimeConfigProperties.JAVA_BEAN_CACHE_SIZE)
    //Is should be weak keys to avoid classloader leaks
    .weakKeys()
    .weakValues()
    .build[Class[_], BeanDefinition]()

  def getBeanDefinition(bean: Any)(implicit ctx: EvaluationContext): BeanDefinition = {
    val clazz = bean.getClass
    cache.get(clazz, key => {
      val clazzDefinition = ClassBeanDefinitionLookup.getClassDefinition(key, ctx.serviceManager.settingsService)
      new BeanDefinition(clazzDefinition)
    })
  }
}

object BeanConstants {
  val GET_PREFIX: String = "get"
  val SET_PREFIX: String = "set"
  val IS_PREFIX: String = "is"
}

object NameGenerator {

  /**
    * Returns a String which capitalizes the first letter of the string.
    */
  def capitalizeJavaConvention(name: String): String = {
    if (name == null || name.isEmpty || (name.length > 1 && Character.isUpperCase(name.charAt(1))) || Character.isUpperCase(name.charAt(0))) {
      name
    } else {
      name.substring(0, 1).toUpperCase(ENGLISH) + name.substring(1)
    }
  }

  def lowerJavaConvention(name: String): String = {
    if (name == null || name.isEmpty || (name.length > 1 && Character.isUpperCase(name.charAt(1)))) {
      name
    } else {
      name.substring(0, 1).toLowerCase(ENGLISH) + name.substring(1)
    }
  }
}
