package org.mule.weave.v2.module.pojo.writer.entry

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.model.structure.schema.Schema
import org.mule.weave.v2.module.commons.java.writer.converter.BaseJavaDataConverter
import org.mule.weave.v2.module.commons.java.writer.entry.WriterEntry
import org.mule.weave.v2.module.pojo.exception.JavaPropertySetException
import org.mule.weave.v2.module.pojo.reader.PropertyDefinition
import org.mule.weave.v2.module.pojo.writer.converter.JavaDataConverter
import org.mule.weave.v2.parser.location.LocationCapable

import java.lang.reflect.ParameterizedType
import java.lang.reflect.WildcardType
import java.lang.reflect.{ Type => JType }
import scala.annotation.tailrec

class BeanPropertyEntry(override val location: LocationCapable, val descriptor: PropertyDefinition, val container: Any, override val schemaOption: Option[Schema])(implicit ctx: EvaluationContext) extends WriterEntry {

  override implicit val converter: BaseJavaDataConverter = JavaDataConverter

  override def resolveEntryValue(): Any = container

  override def entryType(): Class[_] = {
    descriptor.classType()
  }

  override def write(value: Any): Unit = {
    val ableToWrite = descriptor.write(container, value.asInstanceOf[Object], location)
    if (!ableToWrite) {
      throw new JavaPropertySetException(location.location(), String.valueOf(value), Option(value).map(_.getClass.getCanonicalName).orNull, descriptor.name, entryType().getCanonicalName)
    }
  }

  override def genericType(index: Int): Option[Class[_]] = {
    descriptor.genericType() match {
      case Some(t) => resolveType(t, index)
      case _       => None
    }
  }

  @tailrec
  private def resolveType(returnType: JType, index: Int): Option[Class[_]] = {
    returnType match {
      case pt: ParameterizedType => {
        if (pt.getActualTypeArguments.length > index) {
          val typeArgumentAt = pt.getActualTypeArguments()(index)
          toClassType(typeArgumentAt)
        } else {
          None
        }
      }
      case wt: WildcardType => {
        val lowerBounds: Array[JType] = wt.getLowerBounds
        val upperBounds: Array[JType] = wt.getUpperBounds
        if (lowerBounds.nonEmpty) {
          resolveType(lowerBounds(index), index)
        } else if (upperBounds.nonEmpty) {
          resolveType(upperBounds(index), index)
        } else {
          None
        }
      }
      case cl: Class[_] => Some(cl)
      case _ => {
        None
      }

    }
  }

  private def toClassType(typeDef: JType): Option[Class[_]] = {
    typeDef match {
      case cl: Class[_]          => Some(cl)
      case pt: ParameterizedType => toClassType(pt.getRawType)
      case wt: WildcardType => {
        val lowerBounds: Array[JType] = wt.getLowerBounds
        val upperBounds: Array[JType] = wt.getUpperBounds
        if (lowerBounds.nonEmpty) {
          toClassType(lowerBounds.head)
        } else if (upperBounds.nonEmpty) {
          toClassType(upperBounds.head)
        } else {
          None
        }
      }
      case _ => None
    }
  }
}
