package org.mule.weave.v2.module.javaplain.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.parser.location.SimpleLocation

case class UnsupportedJavaValueException(name: String, clazz: Class[_]) extends ExecutionException {

  override def message: String = s"java-plain module is unable to read class ${clazz.getName} from input $name"

  override def location: Location = SimpleLocation(name)
}
