package org.mule.weave.v2.module.javaplain.reader

import org.mule.weave.v2.model.EvaluationContext
import org.mule.weave.v2.module.DataFormat
import org.mule.weave.v2.module.commons.java.reader.BaseJavaReader
import org.mule.weave.v2.module.commons.java.value.JavaValueConverter
import org.mule.weave.v2.module.javaplain.JavaPlainDataFormat

class JavaPlainReader(val rootValue: Any)(implicit ctx: EvaluationContext) extends BaseJavaReader {

  override def context: EvaluationContext = ctx

  override def converter: JavaValueConverter = JavaPlainValueConverter

  override def dataFormat: Option[DataFormat[_, _]] = Some(new JavaPlainDataFormat)
}

object JavaPlainReader {
  def apply(value: Any)(implicit ctx: EvaluationContext): JavaPlainReader = {
    new JavaPlainReader(value)
  }
}

