package org.mule.weave.v2.module.javaplain.interpreted.contribution

import org.mule.weave.v2.core.env.WeaveRuntime
import org.mule.weave.v2.interpreted.contribution.FunctionBodyExpressionNodeContribution
import org.mule.weave.v2.interpreted.node.ValueNode
import org.mule.weave.v2.interpreted.node.structure.function.FunctionParameterNode
import org.mule.weave.v2.module.javaplain.api.contribution.JavaPlainBasedFunction
import org.mule.weave.v2.module.javaplain.api.contribution.JavaPlainBasedFunctionProvider
import org.mule.weave.v2.module.javaplain.api.contribution.NullaryJavaPlainBasedFunction
import org.mule.weave.v2.module.javaplain.exception.InvalidNullaryJavaPlainBasedFunctionArgumentException
import org.mule.weave.v2.module.javaplain.interpreted.node.structure.function.JavaPlainBasedFunctionBodyValueNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.WeaveLocation

class JavaPlainFunctionBodyExpressionNodeContribution extends FunctionBodyExpressionNodeContribution {

  override def getFunctionBodyExpressionNode(module: NameIdentifier, function: String, parameters: Array[FunctionParameterNode], location: WeaveLocation): Option[ValueNode[Any]] = {
    val maybeJavaPlainBasedFunctionWithModule = JavaPlainBasedFunctionManager.getFunction(module, function)
    if (maybeJavaPlainBasedFunctionWithModule.isDefined) {
      val javaPlainBasedFunctionWithModule = maybeJavaPlainBasedFunctionWithModule.get
      javaPlainBasedFunctionWithModule.fn match {
        case _: NullaryJavaPlainBasedFunction =>
          if (parameters.nonEmpty) {
            throw new InvalidNullaryJavaPlainBasedFunctionArgumentException(location)
          }
        case _ =>
        // Nothing to do!
      }
      Some(new JavaPlainBasedFunctionBodyValueNode(javaPlainBasedFunctionWithModule.functionFQNIdentifier, javaPlainBasedFunctionWithModule.fn, parameters, location))
    } else {
      None
    }
  }
}

object JavaPlainBasedFunctionManager {

  private lazy val functions = WeaveRuntime
    .getServiceProvider()
    .serviceImplementations(classOf[JavaPlainBasedFunctionProvider])
    .flatMap(p => p.functions
      .map(fn => {
        val moduleIdentifier = NameIdentifier(p.moduleFQNIdentifier)
        val fqn = getFunctionFQNIdentifier(moduleIdentifier, fn.functionName)
        (fqn, JavaPlainBasedFunctionWithModule(moduleIdentifier, fn))
      }))
    .toMap

  private def getFunctionFQNIdentifier(moduleIdentifier: NameIdentifier, function: String): NameIdentifier = {
    moduleIdentifier.::(function)
  }

  def getFunction(module: NameIdentifier, function: String): Option[JavaPlainBasedFunctionWithModule] = {
    val fqn = getFunctionFQNIdentifier(module, function)
    functions.get(fqn)
  }
}

case class JavaPlainBasedFunctionWithModule(functionFQNIdentifier: NameIdentifier, fn: JavaPlainBasedFunction)