/**
* To use this module, you must import it to your DataWeave code, for example,
* by adding the line `import * from dw::javaplain::Functions` to the header of your
* DataWeave script.
*/
%dw 2.0

/**
* Invokes a `JavaPlainBasedFunction` function.
*
* === Parameters
*
* [%header, cols="1,1,3"]
* |===
* | Name | Type | Description
* | moduleFQNIdentifier | `String` | The fully qualified name of the module identifier.
* | functionName | `String` | The function local function name.
* | args | `Array` | The argument values.
* |===
*/
fun invoke<R>(moduleFQNIdentifier: String, functionName: String, args: Array<Any>): R = native("javaplain::JavaPlainInvokeFunction")