package org.mule.weave.v2.module.javaplain.writer

import org.mule.weave.v2.module.commons.java.writer.JavaWriterSettings
import org.mule.weave.v2.module.javaplain.writer.JavaPlainWriterSettings.PassthroughValueOptionName
import org.mule.weave.v2.module.option.BooleanModuleOption
import org.mule.weave.v2.module.option.ModuleOption

class JavaPlainWriterSettings extends JavaWriterSettings {

  var passthroughValue: Boolean = false

  override def loadSettingsOptions(): Map[String, ModuleOption] = {
    super.loadSettingsOptions() +
      BooleanModuleOption(PassthroughValueOptionName, defaultValue = false).markAsInternal()
  }

  protected override def writeSettingsValue(settingName: String, value: Any): Unit = {
    settingName match {
      case PassthroughValueOptionName =>
        this.passthroughValue = value.asInstanceOf[Boolean]
      case _ =>
        super.writeSettingsValue(settingName, value)
    }
  }
}

object JavaPlainWriterSettings {
  val PassthroughValueOptionName: String = "passthroughValue"
}