package org.mule.weave.v2.module.javaplain.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.Location

class JavaPlainBasedFunctionExecutionException(functionFQNIdentifier: NameIdentifier, val location: Location, cause: String) extends ExecutionException {

  override def message: String = {
    s"Exception while execution JavaPlainBasedFunction: `${functionFQNIdentifier.fullQualifiedName()}`. Caused by: $cause"
  }
}
